package org.unlaxer.jaddress.entity.zip;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.unlaxer.util.collection.Comparators;

public interface ZipBasedAddress {
	
	/*
	 http://jusyo.jp/csv/document.html
	
	No	項目名	説　明
	1	住所CD	住所コード。プライマリーコードになります。
		郵便番号＋独自の２桁です。市区町村合併の際も同一番号を保持します。
		ただし、区画整理・郵便番号の区分け変更などが行われた場合は、この限りではありませんのでご注意ください。
	2	都道府県CD	都道府県コード。２桁。全国地方公共団体コードの左２桁です。
	3	市区町村CD	市区町村コード。５桁。JIS規格で定められた全国地方公共団体コードです。
		市区町村合併、市制施行、政令指定都市への移行などが行われた場合、変更となります。
	4	町域CD	町域コード。９桁。市区町村コード＋独自の４桁です。
		市区町村コードが変更となった場合、伴って変更となります
	5	郵便番号	７桁郵便番号。半角数字。"000-0000"のように、ハイフンが入ります。
		大口事業所個別の番号も含まれます。
	6	事業所フラグ	事業所データの場合[ 1 ]になります。それ以外は[ 0 ]です。
		※住所のデータのみ または 事業所のデータのみを抽出する場合は、このフラグにて判別してください。
	7	廃止フラグ	2010年1月更新分のデータから廃止された住所には[ 1 ]になります。
		それ以外は[ 0 ]になります。
		※現在有効なデータのみを抽出する場合は、このフラグにて判別してください。
	8	都道府県	漢字。
	9	都道府県カナ	全角カタカナ。
	10	市区町村	漢字。
	11	市区町村カナ	全角カタカナ。
	12	町域	漢字。
	13	町域カナ	全角カタカナ。
	14	町域補足	同じ町域が複数レコードある場合、この項目で区別します。
		１．町域が空欄となるとき、以下の内容で区別します。
		“（該当なし）”　他に町域の記載がないときにはここに含まれる
		“（直番地）”　　市区町村名のあとに番地が続く
		“（全域）”　　　一市区町村に対し、一つの郵便番号のみ
		２．同じ町域（漢字）でも町域カナが異なるとき、町域補足で区別します。
		“（－チョウ）”　例：愛知県大府市北崎町　（キタサキチョウ）　
		“（－マチ）”　　例：愛知県大府市北崎町　（キタサキマチ）　
	15	京都通り名	京都市内で用いられる住所表記です。町域の前に記載するもの。同じ町域が離れて存在する場合、この表記により区別が可能です。
	16	字丁目	小字、町域Top1、高層ビル各階の名称が入ります。町域の後に記載するもの。
	17	字丁目カナ	字丁目のカナです。
		「３丁目」「９階」などアラビア数字を含む場合、「０３チョウメ」「０９カイ」のように２桁の０詰めとなっています（ソート時に数字順に並ばせるため）。
	18	補足	住所としてそのまま利用できません。（○番地～○番地）、（その他）といった表記で記載されます。同じ町域でも郵便番号が分かれている場合、この項目で区別する場合があります。
	19	事業所名	事業所に個別の郵便番号が割りあてられている場合、(6)事業所フラグに[ 1 ]が付きます。ここには大口事業所名（漢字）が入ります。
	20	事業所名カナ	カナは「ジギヨウシヨ」のように促音・拗音が大文字となっています。
	21	事業所住所	住所は町域から番地までを収録しています（日本郵便に登録されている部分のみです）。
	22	新住所CD	住所が廃止された場合(7)廃止フラグを[ 1 ]とし、移行先の住所CDが判明していればこの項目に記載します。(現在未使用です)
	
	*/
	/*
				"CREATE TABLE ad_address ( id integer PRIMARY KEY, zip CHAR(7) not null, kenName VARCHAR(4) , cityName VARCHAR(12) , townName VARCHAR(25) , townMemo VARCHAR(256), kenFuri VARCHAR(8) , cityFuri VARCHAR(24) , memo VARCHAR(384))",
				"CREATE INDEX idx_ad1  on ad_address (zip)");

	*/

	Map<String, Object> toMap();

	long id();

	String zip();

	String kenName();
	String cityName();
	String townName();
	
	//郵便番号辞書にtownNameがない場合、ほかの辞書や広域に含まれるすべての町の名前をここに入れる。
	//0000で終わる郵便番号など
	Set<String> supplementaryTownNames();
	
	default Set<String> allTownNames(){
		if(supplementaryTownNames().isEmpty()) {
			return Set.of(townName());
		}
		TreeSet<String> treeSet = new TreeSet<String>(Comparators.longerIsFirst);
		treeSet.add(townName());
		treeSet.addAll(supplementaryTownNames());
		return treeSet;
		
	}

	void setSupplementaryTownNames(Set<String>  townNames);
	
	boolean hasTown();

	String townMemo();
	String kenFuri();
	String cityFuri();
	String memo();
	
	ZipBasedAddress normalize();
	
//	void setKenName(String value);
//	void setCityName(String value);
//	void setTownName(String value);
//
//	void setTownMemo(String value);
//	void setKenFuri(String value);
//	void setCityFuri(String value);
//	void setMemo(String value);
	
	// <li>一町域が二以上の郵便番号で表される場合の表示 （注3） （「1」は該当、「0」は該当せず）</li>
	// public String flg1;
	boolean 一町域が二以上の郵便番号で表される();

	// <li>小字毎に番地が起番されている町域の表示 （注4） （「1」は該当、「0」は該当せず）</li>
	//public String flg2;
	boolean 小字毎に番地が起番されている町域();

	// <li>丁目を有する町域の場合の表示 （「1」は該当、「0」は該当せず）</li>
	//public String flg3;
	boolean 丁目を有する町域();

	// <li>一つの郵便番号で二以上の町域を表す場合の表示 （注5） （「1」は該当、「0」は該当せず）</li>
	//public String flg4;
	boolean 一つの郵便番号で二以上の町域();

	// <li>更新の表示（注6）（「0」は変更なし、「1」は変更あり、「2」廃止（廃止データのみ使用））</li>地方
	//public String flg5;
	UpdateOrDelete 更新or削除();
	
	// <li>変更理由
	// （「0」は変更なし、「1」市政・区政・町政・分区・政令指定都市施行、「2」住居表示の実施、「3」区画整理、「4」郵便区調整等、「5」訂正、「6」廃止（廃止データのみ使用））</li>
	//public String flg6;
	変更理由 変更理由();

	// の次に番地がくる場合=1,else=0
	//public String flg7;
	boolean 町名無し次に番地が来る();
	
	public enum UpdateOrDelete{
		変更なし,
		変更あり,
		廃止
		;
		public static UpdateOrDelete from(String value) {
			int order = Integer.valueOf(value);
			return values()[order];
		}
	}
	
	public enum 変更理由{
		変更なし,
		市政_区政_町政_分区_政令指定都市施行,
		住居表示の実施,
		区画整理,
		郵便区調整等,
		訂正,
		廃止
		;
		public static 変更理由 from(String value) {
			int order = Integer.valueOf(value);
			return values()[order];
		}
	}
	

}