package org.unlaxer.jaddress.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

import org.unlaxer.jaddress.parser.AddressesIndex;

public class ListsAndSeparator<T> implements Comparable<ListsAndSeparator<T>> , Serializable{
	
	private static final long serialVersionUID = 3144911273939060912L;
	
	final List<T> lefts;
	final T separotr;
	final List<T> rights;
	final int hashCode;
	
	public ListsAndSeparator(List<T> lefts, T separotr, List<T> rights) {
		super();
		this.lefts = lefts;
		this.separotr = separotr;
		this.rights = rights;
        int result = 1;
        result = 31 * result + hash(result , lefts);
        result = 31 * result + Objects.hash(separotr);
        result = 31 * result + hash(result , rights);
        hashCode = result;
	}
	
	public ListsAndSeparator(List<T> lefts, T separotr) {
		super();
		this.lefts = lefts;
		this.separotr = separotr;
		this.rights = null;
        int result = 1;
        result = 31 * result + hash(result , lefts);
        result = 31 * result + Objects.hash(separotr);
        hashCode = result;
	}
	
	public ListsAndSeparator(List<T> lefts) {
		super();
		this.lefts = lefts;
		this.separotr = null;
		this.rights = null;
        int result = 1;
        result = 31 * result + hash(result , lefts);
        hashCode = result;
	}
		
	public List<T> left(){
		return lefts;
	}
	
	public Optional<T> separotr(){
		return Optional.ofNullable(separotr);
	}

	public List<T> right(){
		return rights == null ? Collections.emptyList() : rights;
	}
	
	public Stream<T> all(){
		
		return Stream.concat(Stream.concat(lefts.stream(), safeStream(separotr)) , safeStream(rights));
	}
	
	Stream<T> safeStream(List<T> list){
		
		return list == null ? Stream.empty() : list.stream();
	}
	
	Stream<T> safeStream(T entity){
		
		return entity == null ?  Stream.empty() : Stream.of(entity);
	}
	
	public List<T> allAsList(){
		
		List<T> result = new ArrayList<>();
		result.addAll(lefts);
		if(separotr != null) {
			result.add(separotr);
		}
		if(rights != null) {
			result.addAll(rights);
		}
		return result;
	}
	
	public ListsAndSeparator<T> create(AddressesIndex indexOfTarget , Function<T , List<T>> separtorFunction){
		
		return create(allAsList() , indexOfTarget , separtorFunction);
		
	}
		

	
	public ListsAndSeparator<T> create(List<T> sourceList , AddressesIndex indexOfTarget , Function<T , List<T>> separtorFunction){
		
		List<T> left= sourceList.subList(0, indexOfTarget.value);
		T target = sourceList.get(indexOfTarget.value);
		
		List<T> separators = separtorFunction.apply(target);
		
		List<T> right = sourceList.subList(indexOfTarget .value , sourceList.size());
		
		List<T> results = new ArrayList<>();
		
		results.addAll(left);
		results.addAll(separators);
		results.addAll(right);
		
		return new ListsAndSeparator<>(results);
	}

	
	@SuppressWarnings("unchecked")
    private static <U1 extends Comparable<? super U1>> int compareTo(ListsAndSeparator<?> o1, ListsAndSeparator<?> o2) {
        final ListsAndSeparator<U1> t1 = (ListsAndSeparator<U1>) o1;
        final ListsAndSeparator<U1> t2 = (ListsAndSeparator<U1>) o2;

        final int check1 = compareTo(t1.lefts , t2.lefts);
        if (check1 != 0) {
            return check1;
        }

        final int check2 = t1.separotr.compareTo(t2.separotr);
        if (check2 != 0) {
            return check2;
        }

        final int check3 = compareTo(t1.rights , t2.rights);
        if (check3 != 0) {
            return check3;
        }
        return 0;
    }

	@Override
	public int compareTo(ListsAndSeparator<T> other) {
		return ListsAndSeparator.compareTo(this, other);
	}

	@Override
	public int hashCode() {
		return hashCode;
	}
	
	
	
	@SuppressWarnings("unchecked")
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if(hashCode() != obj.hashCode()) {
			return false;
		}
		ListsAndSeparator<T> other = (ListsAndSeparator<T>) obj;
		if (separotr == null) {
			if (other.separotr != null)
				return false;
		} else if (!separotr.equals(other.separotr))
			return false;
		if (hashCode != other.hashCode)
			return false;
		if (lefts == null) {
			if (other.lefts != null)
				return false;
		} else if (!lefts.equals(other.lefts))
			return false;
		if (rights == null) {
			if (other.rights != null)
				return false;
		} else if (!rights.equals(other.rights))
			return false;
		return true;
	}

	int hash(int currentHash , List<T> list) {
		
		for (T t : list) {
			currentHash = 31 * currentHash +  Objects.hash(t);
		}
		return currentHash;
	}
	
	@SuppressWarnings("unchecked")
    private static <U extends Comparable<? super U>> int compareTo(List<?> o1, List<?> o2) {
		
		if(o2 == null) {
			return 1;
		}
		
        final List<U> t1 = (List<U>) o1;
        final List<U> t2 = (List<U>) o2;
        
        int size1 = o1.size();
        int size2 = o1.size();
        
        final int sizeCheck = size1 - size2;
        
        if(sizeCheck != 0) {
        	
        	return sizeCheck; 
        }
        
        for(int i = 0 ; i < t1.size() ; i++) {
        	
        	U u1 = t1.get(i);
        	U u2 = t2.get(i);
        	
        	
            final int check = u1.compareTo(u2);
            if (check != 0) {
                return check;
            }
        }
        return 0;
	}
}
