package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.unlaxer.jaddress.entity.standard.IDHolder;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.util.collection.ID;
import org.unlaxer.util.collection.TreeNode;
import org.unlaxer.util.collection.TreeNodeList;

public interface AddressContext extends  IDHolder {
	
	public enum Kind{
		overAllAddresses,
		partialAddress,
		;
		public boolean isOverAll() {
			return this == overAllAddresses;
		}
		public boolean isPartial() {
			return this == partialAddress;
		}
	}

	String SEPARATOR = " ";
	
	Kind kind();

	void addChildren(TreeNode<AddressElement> target, TreeNodeList<AddressElement> children);

	void addChild(TreeNode<AddressElement> target, TreeNode<AddressElement> child);

	void addChild(TreeNode<AddressElement> target, AddressElement child);

	void addChild(int index, TreeNode<AddressElement> target, AddressElement child);

	Optional<TreeNode<AddressElement>> find(IDHolder hierarchyElement);
	
	Map<階層要素, AddressElement> 丁目以降枝番までAsMap();
	
	List<AddressElement> 丁目以降枝番までAsList();
	
	List<AddressElement> originalAddresses();
	
	PickerResults pickerResults();

	郵便番号 zip();
	
	StringAndCharacterKinds addressString();
	
	TreeNode<AddressElement> addressTree();

	TreeNodeList<AddressElement> split(
			TreeNode<AddressElement> targetNode, 
			SeparatorWithKind separatorWithKind,
			SplitStrategy splitStrategy, 
			SingleOrRange階層要素...  elementKinds);

	
	
	private static AddressContext create(Kind kind , ID id , 郵便番号 zip, List<AddressElement> addresses) {
		return new AddressContextImpl(
			kind,
			id, 
			zip, 
			addresses);
	}
	
	public static OverAllAddressContext createOverAll(ID id , 郵便番号 zip, List<AddressElement> addresses) {
		return OverAllAddressContext.of(
			create(Kind.overAllAddresses, id , zip, addresses)
		);
	}
	
	public static PartialAddressContext createPartial(ID id , 郵便番号 zip, List<AddressElement> addresses) {
		return PartialAddressContext.of(
			create(Kind.partialAddress, id , zip, addresses)
		);
	}
	
	private static AddressContext create(Kind kind , 郵便番号 zip, List<AddressElement> addresses) {
		return create(kind , ID.generate() , zip, addresses);
	}
	
	public static OverAllAddressContext createOverAll(郵便番号 zip, List<AddressElement> addresses) {
		return OverAllAddressContext.of(
			create(Kind.overAllAddresses, zip, addresses)
		);
	}
	
	public static PartialAddressContext createPartial(郵便番号 zip, List<AddressElement> addresses) {
		return PartialAddressContext.of(
			create(Kind.partialAddress, zip, addresses)
		);
	}

	

	static AddressContext create(Kind kind , ID id, 郵便番号 zip, AddressElement addressElement) {
		return new AddressContextImpl(
			kind,
			id, 
			zip, 
			addressElement);
	}
	
}