package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.unlaxer.jaddress.entity.standard.IDHolder;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.entity.zip.ZipBasedAddress;
import org.unlaxer.jaddress.parser.processor.BlockHierarchyResolver.BlockPatternResolverResult;
import org.unlaxer.util.collection.ID;
import org.unlaxer.util.collection.TreeNode;
import org.unlaxer.util.collection.TreeNodeImpl;
import org.unlaxer.util.collection.TreeNodeList;
import org.unlaxer.util.collection.TreeNodeListImpl;

public class AddressContextImpl implements AddressContext {
	
	final 郵便番号 zip;
	
	final List<AddressElement> originalAddresses;
	
	final StringAndCharacterKinds addressString;
	
	List<? extends ZipBasedAddress> jyuusyoJpFromZip;
	
	final TreeNode<AddressElement> addressTree;
	
	final ID id;
	
	final Kind kind;
	
	BlockPatternResolverResult blockPatternResolverResult;
	
	AddressElements result;
	
	BuildingHierarchyResolverResult buildingHierarchy;
	
	ParsingState parsingState;
	
	final PickerResults sources;
	
	public AddressContextImpl(Kind kind , ID id , 郵便番号 zip, List<AddressElement> addresses) {
		super();
		this.kind = kind;
		this.id = id;
		this.zip = zip;
		this.originalAddresses = addresses;
		addressString = StringAndCharacterKinds.of(addresses.stream()
			.map(AddressElement::asString)
			.map(String::trim)
			.collect(Collectors.joining(SEPARATOR)) , false);
		AddressElement root = AddressElementFactory.of(addressString, 定義済みRange階層要素.全体 , SeparatorKind.terminator , SeparatorKind.terminator);
		
		addressTree = create(root);
		
		sources = new PickerResults();
	}
	
	public AddressContextImpl(Kind kind , ID id , 郵便番号 zip, AddressElement addressElement) {
		super();
		this.kind = kind;
		this.id = id;
		this.zip = zip;
		this.originalAddresses = List.of(addressElement);
		addressString = addressElement.stringAndCharacterKinds();
		AddressElement root = addressElement;
		addressTree = create(root);
		
		sources = new PickerResults();
	}

	
	@Override
	public void addChildren(TreeNode<AddressElement> target , TreeNodeList<AddressElement> children) {
		target.addChildren(children);
		LoggerContext.addChild(target.get(), children.unwrap());
	}
	
	@Override
	public void addChild(TreeNode<AddressElement> target , TreeNode<AddressElement> child) {
		target.addChild(child);
		LoggerContext.addChild(target.get(), child.get());
	}
	
	@Override
	public void addChild(TreeNode<AddressElement> target , AddressElement child) {
		target.addChild(create(child));
		LoggerContext.addChild(target.get(), child);
	}
	
	@Override
	public void addChild(int index , TreeNode<AddressElement> target , AddressElement child) {
		target.addChild(index, create(child));
		LoggerContext.addChild(index,target.get(), child);
	}

	
	static TreeNode<AddressElement> create(AddressElement addressElement){
		return new TreeNodeImpl<>(addressElement.id(), addressElement);
	}
	
	
//	@Override
//	public List<? extends JyuusyoJP> jyuusyoJpFromZip() {
//		return jyuusyoJpFromZip;
//	}
	
	@Override
	public Optional<TreeNode<AddressElement>> find(IDHolder hierarchyElement){
		return addressTree.find(hierarchyElement.id());
	}
	
	@Override
	public TreeNodeList<AddressElement> split(
			TreeNode<AddressElement> targetNode , 
			SeparatorWithKind separatorWithKind , 
			SplitStrategy splitStrategy , 
			SingleOrRange階層要素... elementKinds){
		
		AddressElement addressElement = targetNode.get();
		
		List<AddressElement> split = addressElement.split(separatorWithKind, splitStrategy, elementKinds);
		
		TreeNodeList<AddressElement> results = new TreeNodeListImpl<>();
		
		for (AddressElement splitedAddressElement : split) {
			results.add(new TreeNodeImpl<>(splitedAddressElement.id() , splitedAddressElement , targetNode));
		}
		
		return results;
	}
	
	@Override
	public Map<階層要素 , AddressElement> 丁目以降枝番までAsMap(){
		
		return 丁目以降枝番までAsStream()
				.collect(Collectors.toMap(AddressElement::階層要素Force, Function.identity()));
	}
	
	@Override
	public List<AddressElement> 丁目以降枝番までAsList(){
		
		return 丁目以降枝番までAsStream()
				.collect(Collectors.toList());
	}

	
	Stream<AddressElement> 丁目以降枝番までAsStream(){
		
		return Stream.of(
				find(階層要素.町域Top1),
				find(階層要素.町域Top2),
				find(階層要素.町域Top3),
				find(階層要素.町域Top4)
		)
		.filter(Optional::isPresent)
		.map(Optional::get)
		.map(TreeNode::get);
	}
	
//	@Override
//	public void setBlockPatternResolverResult(BlockPatternResolverResult blockPatternResolverResult) {
//		this.blockPatternResolverResult = blockPatternResolverResult;
//		
//		LoggerContext.debug("set BlockPatternResolverResult : {}", blockPatternResolverResult.toString());
//	}
//	
//	@Override
//	public BlockPatternResolverResult blockPatternResolverResult(){
//		return blockPatternResolverResult;
//	}
	
	@Override
	public PickerResults pickerResults() {
		return sources;
	}
	
//	@Override
//	public Either<ParsingState, AddressElements> results(){
//		return result == null ? 
//				Either.leftOf(parsingState) :
//				Either.rightOf(result);
//	}
//	
//	@Override
//	public void setResult(AddressElements result) {
//		this.result = result;
//	}
//	
//	@Override
//	public void setBlockPatternResolverResult(BuildingHierarchyResolverResult buildingHierarchy) {
//		this.buildingHierarchy = buildingHierarchy;
//	}
//	
//	@Override
//	public BuildingHierarchyResolverResult buildingHierarchy() {
//		return buildingHierarchy;
//	}
//	
//	@Override
//	public void setParsingState(ParsingState state) {
//		this.parsingState = state;
//	}
//
//	@Override
//	public void setJyuusyoJpFromZip(List<? extends JyuusyoJP> jyuusyoJpFromZip) {
//		this.jyuusyoJpFromZip = jyuusyoJpFromZip;		
//	}

	@Override
	public ID id() {
		return id;
	}

	@Override
	public 郵便番号 zip() {
		return zip;
	}

	@Override
	public StringAndCharacterKinds addressString() {
		return addressString;
	}

	@Override
	public TreeNode<AddressElement> addressTree() {
		return addressTree;
	}

	@Override
	public Kind kind() {
		return kind;
	}

	@Override
	public List<AddressElement> originalAddresses() {
		return originalAddresses;
	}

}