package org.unlaxer.jaddress.parser;


import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

import org.unlaxer.jaddress.entity.standard.IDHolder;
import org.unlaxer.jaddress.entity.standard.LevelHolder;
import org.unlaxer.jaddress.entity.standard.NameHolder;
import org.unlaxer.jaddress.entity.standard.OffsetHolder;
import org.unlaxer.jaddress.entity.standard.OffsetOfBlock;
import org.unlaxer.jaddress.entity.standard.OffsetOfBuilding;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.util.collection.ID;

public class AddressElement extends AddressTokenImpl implements IDHolder , LevelHolder ,  OffsetHolder , NameHolder{

	final SingleOrRange階層要素 _階層要素;
	
	public Optional<OffsetOfBlock> offsetOfBlock = Optional.empty();
	public Optional<OffsetOfBuilding> offsetOfBuilding = Optional.empty();
	
	public static final Comparator<AddressElement> big階層要素OrdinalIsTop = 
			(element1 , element2)-> element2._階層要素.ordinal() - element1._階層要素.ordinal();
			
	public static AddressElement of(String colonSeparatedAddressString) {
		return fromColonSeparatedValue(colonSeparatedAddressString);
	}
			
	AddressElement(String value) {
		this(value , SingleOrRange階層要素.of(階層要素.不明));
	}
	
	public AddressElement(String value, SingleOrRange階層要素 _階層要素) {
		this(value , _階層要素 ,SeparatorKind.terminator , SeparatorKind.terminator );
	}
	
	public AddressElement(
			String value,
			SingleOrRange階層要素 _階層要素 ,
			SeparatorKind separatorKindOfLeading,
			SeparatorKind separatorKindOfTailing) {
		super(
			StringAndCharacterKinds.of(value.strip() , false),
			separatorKindOfLeading,
			separatorKindOfTailing
		);
		this._階層要素 = _階層要素;
	}
	
	public  AddressElement(StringAndCharacterKinds stringAndCharacterKinds, SingleOrRange階層要素 _階層要素) {
		this(stringAndCharacterKinds , _階層要素 ,SeparatorKind.terminator , SeparatorKind.terminator );
	}
	
	public AddressElement(
			StringAndCharacterKinds stringAndCharacterKinds, 
			SingleOrRange階層要素 _階層要素,
			SeparatorKind separatorKindOfLeading,
			SeparatorKind separatorKindOfTailing) {
		super(
				stringAndCharacterKinds.strip(),
				separatorKindOfLeading,
				separatorKindOfTailing
			);
		this._階層要素 = _階層要素;
	}
	
	public AddressElement(AddressToken addressToken, SingleOrRange階層要素 _階層要素) {
		super(addressToken.strip());
		this._階層要素 = _階層要素;
	}

	public boolean isEmpty() {
		return _階層要素.階層要素().map(_階層要素->_階層要素 == 階層要素.空).orElse(false);
	}
	
	public static AddressElement empty () {
		return new AddressElement("", new SingleOrRange階層要素(階層要素.空) , SeparatorKind.terminator , SeparatorKind.terminator);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((_階層要素 == null) ? 0 : _階層要素.hashCode());
		result = prime * result + ((stringAndCharacterKinds == null) ? 0 : stringAndCharacterKinds.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AddressElement other = (AddressElement) obj;
		if (_階層要素 != other._階層要素)
			return false;
		if (stringAndCharacterKinds == null) {
			if (other.stringAndCharacterKinds != null)
				return false;
		} else if (!stringAndCharacterKinds.equals(other.stringAndCharacterKinds))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return _階層要素+":" + super.toString();
//			prefix().map(x->"[" + x  +"]").orElse("")+
//			stringAndCharacterKinds.joined() + 
//			suffix().map(x->"[" + x  +"]").orElse("");
	}

	public Optional<階層要素> 階層要素() {
		return _階層要素.階層要素();
	}
	
	public 階層要素 start階層要素() {
		return _階層要素.start階層要素();
	}

	public 階層要素 end階層要素() {
		return _階層要素.end階層要素();
	}
	
	public SingleOrRange階層要素 singleOrRange階層要素() {
		return _階層要素;
	}
	public 階層要素 階層要素Force() {
		return _階層要素.階層要素().get();
	}
	
	public Optional<定義済みRange階層要素> 定義済みRange階層要素() {
		return _階層要素.定義済みRange階層要素();
	}
	
	@Override
	public int level() {
		return _階層要素.level();
	}
	
	public StringAndCharacterKinds stringAndCharacterKinds() {
		return stringAndCharacterKinds;
	}
	
	public List<AddressElement> split(
			SeparatorWithKind separatorWithKind , 
			SplitStrategy splitStrategy , 
			SingleOrRange階層要素... 階層要素群){
		
		int kinds = 階層要素群.length;
		
		if(splitStrategy.tupleLenght != kinds) {
			throw new IllegalArgumentException();
		}
		
		String value = stringAndCharacterKinds.joined();
		
		SeparatorKind separatorKind = separatorWithKind.separatorKind;
		
		String separator =separatorWithKind.separator();
		
		//TODO match with similar word
		int indexOf = value.indexOf(separator);
		
		int kindIndex = 0;
		
		if(indexOf != -1) {
			
			List<AddressElement> results = new ArrayList<>();
			
			int leftEnd = splitStrategy.isTuple3() || splitStrategy.isTuple2_SeparatorJoinWithRight() ?
					indexOf :
					indexOf + separator.length();
			
			String left = value.substring(0,leftEnd);
			
			SingleOrRange階層要素 leftKind = 階層要素群[kindIndex++];
			results.add( new AddressElement(left, leftKind , separatorKindOfLeading , separatorKind));
			
			if(splitStrategy.isTuple3()) {
				
				String center = value.substring(leftEnd , leftEnd + separator.length());

				SingleOrRange階層要素 centerKind = 階層要素群[kindIndex++];
				results.add(new AddressElement(center, centerKind , separatorKind , separatorKind));
			}
			
			String right = value.substring(leftEnd , value.length());
			
			SingleOrRange階層要素  rightKind = 階層要素群[kindIndex++];
			results.add(new AddressElement(right, rightKind , separatorKind , separatorKindOfTailing));
			
			return results;
		}
		return List.of(this);
	}
	
	
	public AddressElement strip() {
		AddressElement addressElement = new AddressElement(stringAndCharacterKinds.stripIncludesSymbols(), _階層要素);
		prefix().ifPresent(addressElement::setPrefix);
		suffix().ifPresent(addressElement::setSuffix);
		return addressElement;
	}
	
	@Override
	public ID id() {
		return _階層要素.id();
	}
	
	@Override
	public String name() {
		return _階層要素.name();
	}
	
	public static AddressElement fromColonSeparatedValue(String colonSeparatedValue) {
		
		if(colonSeparatedValue.contains(":")) {
			
			String right = null;
			try {
				int indexOf = colonSeparatedValue.indexOf(':');
				
				String left = colonSeparatedValue.substring(0,indexOf);
				right = colonSeparatedValue.substring(indexOf + 1);
				
					String[] split = left.split("-");
					
					int length = split.length;
					
					int level = Integer.parseInt(split[0]);
					Optional<階層要素> start = 階層要素.byLevel(level);
					
					Optional<階層要素> end =
							length == 2 ?
									階層要素.byLevel(Integer.parseInt(split[1])):
									Optional.empty();
									
					if(start.isPresent() && end.isPresent()){
						
						String rightValue = right; 
						
						AddressElement addressString = 定義済みRange階層要素.of(start.get(), end.get())
							.map(SingleOrRange階層要素::of)
							.map(_階層要素->new AddressElement(rightValue , _階層要素))
							.orElseGet(()->new AddressElement(rightValue));
						
						return  addressString;
						
					}else if(start.isPresent()) {
						
						return new AddressElement(right , SingleOrRange階層要素.of(start.get()));
					}else {
						return new AddressElement(right);
					}
			}catch (Exception e) {
				//skip;
			}
			if(right != null) {
				return new AddressElement(right);
			}
		}
		return new AddressElement(colonSeparatedValue);
	}

	@Override
	public Optional<OffsetOfBlock> offsetOfBlock() {
		return offsetOfBlock;
	}

	@Override
	public Optional<OffsetOfBuilding> offsetOfBuilding() {
		return offsetOfBuilding;
	}

	@Override
	public void setOffsetOfBlock(OffsetOfBlock offsetOfBlock) {
		this.offsetOfBlock = Optional.of(offsetOfBlock);
	}

	@Override
	public void setOffsetOfBuilding(OffsetOfBuilding offsetOfBuilding) {
		this.offsetOfBuilding= Optional.of(offsetOfBuilding);
	}

}