package org.unlaxer.jaddress.parser;

import static guru.nidi.graphviz.model.Factory.graph;
import static guru.nidi.graphviz.model.Factory.node;
import static guru.nidi.graphviz.model.Factory.to;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;

import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.util.collection.TreeNode;

import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.Renderer;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Node;

public class AddressElementTreeRenderer implements AddressRenderer{
	
	public static void writeTo(String name , int width  ,TreeNode<AddressElement> root , Path path) {
		
		Graphviz graphviz = toGraphviz(name, width, root);
		try {
			Renderer render = graphviz.render(Format.PNG);
			render.toFile(path.toFile());
		} catch (IOException e) {
			throw new UncheckedIOException(e);
		}
	}
	
	public static Graphviz toGraphviz(String name , int width  ,TreeNode<AddressElement> root) {
		
		Node rootNode = createNode(root);
		
		Graph g = graph(name).directed().with(rootNode);
		Graphviz graphviz = Graphviz.fromGraph(g).width(width);
		
		return graphviz;
	}
	
	static Node createNode(TreeNode<AddressElement> treeNode) {
		
		AddressElement addressElement = treeNode.get();
		
		String _階層要素 =  addressElement.階層要素()
			.map(階層要素::name)
			.map(x->"\"" + x + "\"")
			.orElse("");
		
		Label lines = Label.lines(
				 _階層要素 ,
				toString(addressElement)
//				(StringUtils.isBlank(addressElement.asString()) ?  "--------" : "\""+addressElement.asString()+"\"")
		);
		
//		List<String> lines = new ArrayList<>();
//			
//		lines.add("<b>" + addressElement.value() + "</b>");
//		lines.add("階層要素:" + addressElement.elementKind);
//		lines.add("addtional:" + addressElement.additional);
//	
//		Label label = Label.htmlLines(lines.toArray(new String[] {}));
		
//		Node node = node(addressElement.value()).with(Shape.RECTANGLE , Style.FILLED , label , Color.WHITE);
//		Node node = node(addressElement.value());
		Node node = node(lines).with(Shape.RECTANGLE ,  Color.BLACK);
		
		for(TreeNode<AddressElement> childTreeNode : treeNode.children()) {
			
			Node childNode = createNode(childTreeNode);
			
			node = node.link(to(childNode));
		}
		return node;
	}
	
	static String toString(AddressElement addressElement) {
		
		String prefix = addressElement.prefix().map(x->"["+x+"]").orElse("");
		String suffix = addressElement.suffix().map(x->"["+x+"]").orElse("");
		
		return prefix +  addressElement.stringAndCharacterKinds.joined() + suffix; 
	}

	
}