package org.unlaxer.jaddress.parser;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.util.collection.ID;
import org.unlaxer.util.collection.TreeNode;
import org.unlaxer.util.collection.TreeNodeList;

public class AddressElements implements AddressContextHolder{
	
	public static final Comparator<MultipleAddressElement> by階層要素Ascending  =
			(lhs,rhs)->lhs.階層要素().level() - rhs.階層要素().level();
			
	final SortedSet<MultipleAddressElement> elements = new TreeSet<MultipleAddressElement>(by階層要素Ascending);
	
	final AddressContext addressContext;
	
	public AddressElements(AddressContext addressContext) {
		super();
		
		this.addressContext = addressContext;
		
		TreeNodeList<AddressElement> TreeNodeLeafs = addressContext.addressTree().leafs();
		
		List<AddressElement> leafs = 
				TreeNodeLeafs.stream()
					.map(TreeNode::get)
					.collect(Collectors.toList());
		
		addAll(leafs);
	}

	void addAll(Collection<AddressElement> elements) {
		this.elements.addAll(
			elements.stream()
				.map(AddressElement::strip)
				.filter(AddressElement::isPresent)
				.map(MultipleAddressElement::new)
				.collect(Collectors.toList())
		);
	}
	
	public Optional<MultipleAddressElement> find(階層要素 _階層要素){
		
		return find(_階層要素.id());
	}
	
	public Optional<MultipleAddressElement> find(ID targetId){
		return elements.stream()
			.filter(addressElement->addressElement.id().equals(targetId))
			.findFirst();
	}
	
	public boolean exists(階層要素 _階層要素){
		
		return exists(_階層要素.id());
	}
	
	public boolean exists(ID targetId){
		return elements.stream()
			.anyMatch(addressElement->addressElement.id().equals(targetId));
	}

	
	public boolean notExists(階層要素 _階層要素){
		return false == exists(_階層要素);
	}
	
	public void add(AddressElement addressElement) {
		
		Optional<MultipleAddressElement> find = find(addressElement.id());
		if(find.isPresent()) {
			find.ifPresent(multipleAddressElement ->
				multipleAddressElement.add(addressElement)
			);
		}else {
			MultipleAddressElement multipleAddressElement = new MultipleAddressElement(addressElement);
			elements.add(multipleAddressElement);
		}
	}
	
	public void overWrite(MultipleAddressElement multipleAddressElement) {
		
		Optional<MultipleAddressElement> find = find(multipleAddressElement.id());
		if(find.isPresent()) {
			find.ifPresent(baseMultipleAddressElement ->{
				elements.remove(baseMultipleAddressElement);
			});
		}
		elements.add(multipleAddressElement);
	}

	
	public SortedSet<MultipleAddressElement> get(){
		return elements;
	}

	@Override
	public String toString() {
		String collect = elements.stream()
			.map(MultipleAddressElement::toString)
			.map(x->"'"+x+"'")
			.collect(Collectors.joining(",", "{", "}"));
		return collect;
	}
	
	public AddressElements overWrite(AddressElements overWritten) {
		
		overWritten.elements.forEach(this::overWrite);
		return this;
	}
	
	@Override
	public AddressContext addressContext() {
		return addressContext;
	}
}