package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.ParseException;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.parser.AddressContext.Kind;
import org.unlaxer.util.collection.ID;
import org.unlaxer.util.collection.TreeNode;

public interface AddressParser {
	
	public enum PoisonPillKind{
		
		WhenParseStart,
		;
		public ID id() {
			return ID.of(this);
		}
	}
	
	static NextStateResolverBy階層要素 stateResolver = new SimpleNextStateResolverBy階層要素();
	
	public Map<ParsingState , AddressProcessor> processorByState();
	
//	public default ParsingResult parse(ParsingParameters parameters) {
//		
//		return parse(
//			parameters.addresses(), 
//			parameters.id(),
//			parameters.zip(),
//			parameters.dataAccessContext(),
//			processorByState(),
//			stateResolver()
//		);
//	}
	
	public default ParsingResult parse(ParsingContext parsingContext) {
		return parseOverAll(parsingContext , processorByState() , stateResolver());
	}
	
	static ParsingResult parseOverAll(
			ParsingContext parsingContext,
			Map<ParsingState, AddressProcessor> processorByState,
			NextStateResolverBy階層要素 stateResolver
			) {
		
		OverAllAddressContext addressContext = parsingContext.overAllAddressContext();
		郵便番号 zip = addressContext.zip();
		ID id = addressContext.id();
		
		List<AddressElement> addresses = addressContext.originalAddresses();
		
		long 不明Count =addresses.stream()
			.map(AddressElement::start階層要素)
			.filter(_階層要素-> _階層要素 == 階層要素.不明)
			.count();
		
		boolean allAddressIs不明 = 不明Count == addresses.size();
		boolean has不明Address = 不明Count >0;
		
		
		if(has不明Address) {
			
			ParsingTarget parsingTarget = ParsingTarget.create(parsingContext, addressContext);
			parsingTarget.createAndSetPoisonPill(
				PoisonPillKind.WhenParseStart.id(), 
				()->new ParseException("this exception is poison pill")
			);
			parsingContext.addParsingTarget(parsingTarget);
			
			if(allAddressIs不明){
				
				ParsingResult parsed = parsePartialAndMerge(parsingContext , processorByState);
				return parsed;
				
			} 
			PartialParsingResult partialParsingResult = 
				PartialParsingResult.create(parsingTarget , ParsingState.入力Address組み合わせエラー);
			partialParsingResult.set(new AddressElements(addressContext));
			
			ParsingResult parsingResult = ParsingResult.create(addressContext , partialParsingResult);
			return parsingResult;
		}
		
		addresses.stream()
			.forEach(addressElement->{
				
				SingleOrRange階層要素 target階層要素 = addressElement.singleOrRange階層要素();
				
				
				PartialAddressContext partialAddressContext = 
					PartialAddressContext.of(AddressContext.create(Kind.partialAddress , id, zip, addressElement));
				
				ParsingState nextState = stateResolver.apply(target階層要素);
				
				TargetStateAndElement targetStateAndElement = new TargetStateAndElement(nextState, target階層要素);
				
				ParsingTarget parsingTarget = 
					ParsingTarget.create(parsingContext, partialAddressContext , targetStateAndElement);
					parsingTarget.createAndSetPoisonPill(
						PoisonPillKind.WhenParseStart.id(), 
						()->new ParseException("this exception is poison pill")
					);
					parsingTarget.apply(parsingContext);
				
				parsingContext.addParsingTarget(parsingTarget);
			});
		
		ParsingResult parsed = parsePartialAndMerge(parsingContext , processorByState);
		return parsed;
	}
	
	
	public default NextStateResolverBy階層要素 stateResolver() {
		return stateResolver;
	}
	
	
	private static ParsingResult parsePartialAndMerge(ParsingContext parsingContext , Map<ParsingState, AddressProcessor> processorByState) {
		
		List<PartialParsingResult> results = parsingContext.parsingTargets().stream()
			.map(parsingTarget->parseParsingTarget(parsingTarget,processorByState))
			.collect(Collectors.toList());
		
		ParsingResult parsingResult = ParsingResult.create(parsingContext.overAllAddressContext() , results);
		
		return parsingResult;
	}

	static Consumer<? super PartialParsingResult> overWriteWithAddressContext(TreeNode<AddressElement> baseAddressTree) {
		
		return currentAddressContext->{
			
			AddressContext addressContext = currentAddressContext.parsingTarget().addressContext();
			
			TreeNode<AddressElement> addritionalTreeNode = addressContext.addressTree().root();
			AddressElement addressElement = addritionalTreeNode.get();
			
			SingleOrRange階層要素 current階層要素 = addressElement._階層要素;
			
			Optional<TreeNode<AddressElement>> targetBaseNode = baseAddressTree.findWithContent(element->{
				return element._階層要素.equals(current階層要素);
			});
			
			targetBaseNode.ifPresent(_targetBaseNode->{
				ID targetId = _targetBaseNode.id();
				_targetBaseNode.parent()
					.ifPresent(parent->parent.resetChild(targetId, addritionalTreeNode));
			});
		};
	}
	
	private static PartialParsingResult parseParsingTarget(ParsingTarget parsingTarget , Map<ParsingState, AddressProcessor> processorByState) {
		
		AddressContext addressContext  = parsingTarget.addressContext();
		
		
		LoggerContext.debug("START:{} {}" , addressContext.zip().asHyphonated() , addressContext.addressString().joined());
		
		//for testing
		parsingTarget.poisonPill(PoisonPillKind.WhenParseStart.id()).run();

		while (true) {
			
			ParsingState targetState = parsingTarget.targetState();
			
			AddressProcessor processor = processorByState.get(targetState);
			
			
			if(processor == null) {
				parsingTarget.addResolverResult(new ResolverResult(new ResolverResultKindOfProcessedProcessor(targetState)));
				break;
			}
			LoggerContext.debug("■ Processor is {}", processor.getClass().getSimpleName());
			
			
			TargetStateAndElement targetStateAndElement = processor.process(parsingTarget);
			parsingTarget.setTargetStateAndElement(targetStateAndElement);
			parsingTarget.addResolverResult(new ResolverResult(new ResolverResultKindOfProcessedProcessor(targetState)));
		}
		LoggerContext.debug("END");
		
		PartialParsingResult partialParsingResult = parsingTarget.partialParsingResult();
		
		return partialParsingResult;
		
	}
}