package org.unlaxer.jaddress.parser;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.util.collection.TreeNode;

public interface AddressProcessor {//extends UnaryOperator<AddressContext>{
	
	public ParsingState targetState();
	
//	public 階層要素 target階層要素();

	public TargetStateAndElement process(ParsingTarget parsingTarget);
	
	public default TreeNode<AddressElement> targetNode(ParsingTarget parsingTarget){
		SingleOrRange階層要素 nextTarget階層要素 = parsingTarget.target階層要素();
		AddressContext addressContext = parsingTarget.addressContext();
		TreeNode<AddressElement> node = addressContext.addressTree().find(nextTarget階層要素.id()).orElseThrow();
		return node;
	}
	
	public default SingleOrRange階層要素 target階層要素(ParsingTarget parsingTarget){
		SingleOrRange階層要素 nextTarget階層要素 = parsingTarget.target階層要素();
		return nextTarget階層要素;
	}

}