package org.unlaxer.jaddress.parser;

import java.util.Optional;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.model.StringValue;


public class AddressString_ extends StringValue{
	
	static Logger logger = LoggerFactory.getLogger(AddressString_.class);
	 
	
	private static final long serialVersionUID = -1891353128689382042L;
	
	final SingleOrRange階層要素  _階層要素;
	
	public AddressString_(String value, SingleOrRange階層要素  _階層要素) {
		super(value);
		this._階層要素 = _階層要素;
	}
	
	public AddressString_(String value) {
		this(value , SingleOrRange階層要素.of(階層要素.不明));
	}

	
	public String value() {
		return value;
	}
	
	public boolean isRanged() {
		return _階層要素.isRange() ;
	}
	
	public boolean isNotRanged() {
		return false == isRanged();
	}
	
	public static AddressString_ fromColonSeparatedValue(String colonSeparatedValue) {
		
		if(colonSeparatedValue.contains(":")) {
			
			String right = null;
			try {
				int indexOf = colonSeparatedValue.indexOf(':');
				
				String left = colonSeparatedValue.substring(0,indexOf);
				right = colonSeparatedValue.substring(indexOf + 1);
				
					String[] split = left.split("-");
					
					int length = split.length;
					
					int level = Integer.parseInt(split[0]);
					Optional<階層要素> start = 階層要素.byLevel(level);
					
					Optional<階層要素> end =
							length == 2 ?
									階層要素.byLevel(Integer.parseInt(split[1])):
									Optional.empty();
									
					if(start.isPresent() && end.isPresent()){
						
						String rightValue = right; 
						
						AddressString_ addressString = 定義済みRange階層要素.of(start.get(), start.get())
							.map(SingleOrRange階層要素::of)
							.map(_階層要素->new AddressString_(rightValue , _階層要素))
							.orElseGet(()->new AddressString_(rightValue));
						
						return  addressString;
						
					}else if(start.isPresent()) {
						
						return new AddressString_(right , SingleOrRange階層要素.of(start.get()));
					}else {
						return new AddressString_(right);
					}
			}catch (Exception e) {
				//skip;
			}
			if(right != null) {
				return new AddressString_(right);
			}
		}
		return new AddressString_(colonSeparatedValue);
	}

	public 階層要素 start階層要素() {
		return _階層要素.start階層要素();
	}

	public 階層要素 end階層要素() {
		return _階層要素.end階層要素();
	}
	
	public SingleOrRange階層要素 階層要素() {
		return _階層要素;
	}
	
}

