package org.unlaxer.jaddress.parser;

import java.util.Optional;

public interface AddressToken {

	StringAndCharacterKinds stringAndCharacterKinds();

	SeparatorKind separatorKindOfLeading();

	SeparatorKind separatorKindOfTailing();

	AddressToken substring(StringIndex beginIndexInclusive, StringIndex endIndexExclusive,
			SeparatorKind leadingSeparator, SeparatorKind tailingSeparator);
	
	default AddressToken substring(StringIndex beginIndexInclusive, 
			SeparatorKind leadingSeparator, SeparatorKind tailingSeparator) {
		return substring(beginIndexInclusive, StringIndex.of(length()) , leadingSeparator, tailingSeparator);
	}

	
	AddressToken subList(ListIndex beginIndexInclusive, ListIndex endIndexExclusive,
			SeparatorKind leadingSeparator, SeparatorKind tailingSeparator);

	AddressToken strip();
	
	public static AddressToken empty() {
		return AddressTokenImpl.empty();
	}

	String asString();

	int length();

	boolean isEmpty();

	boolean isPresent();

	StringIndex indexOf(String word);
	
	Optional<String> prefix();
	Optional<String> suffix();
	
	void setPrefix(String prefix);
	void setSuffix(String suffix);

}