package org.unlaxer.jaddress.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.entity.standard.階層要素;

import io.vavr.control.Either;

public class BlockAndBuildings{
	
	List<Either<StringAndCharacterKind,PhraseAndStrings>> tokens;
	
	public static BlockAndBuildings create(AddressElement addressElement ,SortedSet<String> buidingNames ) {
		String addressString = addressElement.asString();
		
		for (String buildingName : buidingNames) {
			int indexOf = addressString.indexOf(buildingName);
			if(indexOf != -1) {
				StringAndCharacterKinds predecessor = 
						StringAndCharacterKinds.of(addressString.substring(0,indexOf),false);
				PhraseAndStrings building = new PhraseAndStrings(
						Phrase.建物, 
						new StringAndCharacterKinds(
								addressString.substring(indexOf , indexOf + buildingName.length())
						)
				);
				StringAndCharacterKinds successor = 
						StringAndCharacterKinds.of(addressString.substring(indexOf + buildingName.length()),false);
				
				BlockAndBuildings blockAndBuildings= new BlockAndBuildings()
					.add(StringAndCharacterKind.TERMINATOR) // for ease to matching
					.add(predecessor)
					.add(building)
					.add(successor)
					.add(StringAndCharacterKind.TERMINATOR);
				return blockAndBuildings;
			}
		}
		return new BlockAndBuildings(addressElement);
	}
	
	BlockAndBuildings(AddressElement addressElement) {
		this(addressElement.stringAndCharacterKinds);
	}
	
	BlockAndBuildings() {
		tokens = new ArrayList<Either<StringAndCharacterKind,PhraseAndStrings>>();
	}
	
	BlockAndBuildings(StringAndCharacterKinds stringAndCharacterKinds) {
		
		tokens = new ArrayList<Either<StringAndCharacterKind,PhraseAndStrings>>();
		add(StringAndCharacterKind.TERMINATOR);// for ease to matching
		stringAndCharacterKinds.stream()
			.forEach(x-> tokens.add(Either.left(x)));
		add(StringAndCharacterKind.TERMINATOR);

	}
	
	public BlockAndBuildings add(StringAndCharacterKind stringAndCharacterKind) {
		tokens.add(Either.left(stringAndCharacterKind));
		return this;
	}

	
	public BlockAndBuildings add(StringAndCharacterKinds stringAndCharacterKinds) {
		stringAndCharacterKinds.stream()
			.forEach(x-> tokens.add(Either.left(x)));
		return this;
	}
	
	public BlockAndBuildings add(PhraseAndStrings phraseAndStrings) {
		tokens.add(Either.right(phraseAndStrings));
		return this;
	}
	
	public void stripTerminators() {
		Either<StringAndCharacterKind, PhraseAndStrings> either = tokens.get(tokens.size()-1);
		if(either.isLeft() && either.getLeft().characterKind.isTerminator()) {
			tokens.remove(tokens.size()-1);
		}
		either = tokens.get(0);
		if(either.isLeft() && either.getLeft().characterKind.isTerminator()) {
			tokens.remove(0);
		}
	}
	
	public Optional<ListIndex> indexOf(階層要素 _階層要素){
		
		for(int i = 0 ; i < tokens.size() ; i ++) {
			Either<StringAndCharacterKind, PhraseAndStrings> either = tokens.get(i);
			if(either.isRight() && 
					either.get().phrase().target階層要素.map(x->x==_階層要素).orElse(false)) {
				return Optional.of(ListIndex.of(i));
			}
		}
		return Optional.empty();
	}
	
	public List<Either<StringAndCharacterKind,PhraseAndStrings>> tokens(){
		return tokens;
	}
	
	public ListIterator<Either<StringAndCharacterKind,PhraseAndStrings>> listIterator() {
		return tokens.listIterator();
	}

	public ListIterator<Either<StringAndCharacterKind,PhraseAndStrings>> listIterator(int index) {
		return tokens.listIterator(index);
	}
	
	public ListIterator<Either<StringAndCharacterKind,PhraseAndStrings>> listIteratorFromLast() {
		return tokens.listIterator(tokens.size());
	}
	
	public List<Either<StringAndCharacterKind,PhraseAndStrings>> subToken(ListIndex index , int size ){
		return tokens.subList(index.value, index.value+size);
	}
	
	public List<StringAndCharacterKind> subStringAndCharacterKinds(ListIndex index , int size ){
		return tokens.subList(index.value, index.value+size).stream()
				.filter(Either::isLeft)
				.map(Either::getLeft)
				.collect(Collectors.toList());
	}
	
	public void replace(ListIndex index , int size , PhraseAndStrings phraseAndStrings) {
		for(int i = 0 ; i < size ; i++) {
			tokens.remove(index.value);
		}
		tokens.add(index.value, Either.right(phraseAndStrings));
	}

	public List<ListIndex> indexOf(List<? extends Predicate<CharacterKind>> predicates , TopOrBottom from) {
		
		int increment = from.isTop() ? 1 : -1;
		int start = from.isTop() ? 0 : tokens.size() -1;
		int predicteStart = from.isTop() ? 0 : predicates.size() -1;
		
		Predicate<Integer> breakCondition = from.isTop() ?
				counter-> counter >=tokens.size() :
				counter-> counter <0;
				
		Predicate<Integer> predicateBreakCondition = from.isTop() ?
				counter-> counter >=predicates.size() :
				counter-> counter <0;
		
		List<ListIndex> indexes = new ArrayList<ListIndex>();
		
		int i = start;
		int p = predicteStart;
		while(true) {
			Either<StringAndCharacterKind,PhraseAndStrings> either = tokens.get(i);
			if(either.isRight()) {
				
				p = predicteStart;
				i += increment;
				if(breakCondition.test(i)) {
					break;
				}
				continue;
			}
			StringAndCharacterKind left = either.getLeft();
			Predicate<CharacterKind> predicate = predicates.get(p);
			
			if(predicate.test(left.characterKind())) {
				p += increment;
				if(predicateBreakCondition.test(p)) {
					indexes.add(ListIndex.of(
						from.isTop() ?
							i - predicates.size() + 1:
							i
					));
					p = predicteStart;
				}
			}else {
				p = predicteStart;
			}
			
			i += increment;
			if(breakCondition.test(i)) {
				break;
			}
		}
		return indexes;
	}

	@Override
	public String toString() {

		StringBuilder builder = new StringBuilder();
		
		tokens.stream()
			.forEach(either->{
				either.peek(phrase->{
					builder
						.append("[")
						.append(phrase.stringAndCharacterKinds().joined())
						.append("]");
				});
				either.peekLeft(stringAndCharacterKinds->{
					builder
						.append(stringAndCharacterKinds.string);
				});
			});
		
		return builder.toString();
		
	}
	
	
	
}