package org.unlaxer.jaddress.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BlockSeparator implements Serializable , Comparable<BlockSeparator>{
	
	private static final long serialVersionUID = -1209561699121980645L;
	
	public final String separator;
	public final BlockSeparatorKind blockSeparatorKind;
	final int hashCode;
	
	public BlockSeparator(String separator, BlockSeparatorKind blockSeparatorKind) {
		super();
		this.separator = separator;
		this.blockSeparatorKind = blockSeparatorKind;
		hashCode = separator.hashCode();
	}

	@Override
	public int hashCode() {
		return hashCode;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		BlockSeparator other = (BlockSeparator) obj;
		if (separator == null) {
			if (other.separator != null)
				return false;
		} else if (!separator.equals(other.separator))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return separator;
	}

	@Override
	public int compareTo(BlockSeparator other) {
		return separator.compareTo(other.separator);
	}
	
	List<String> split(String clause) {
		
		List<String> results = new ArrayList<>();
		
		int start = 0;
		
		while(true) {
			
			int indexOf = clause.indexOf(separator);
			
			if(indexOf == -1) {
				
				results.add(clause.substring(start , clause.length()));
				break;
			}else {
				results.add(clause.substring(start , indexOf));
				start = indexOf;
			}
		}
		return results;
	}
	
}