package org.unlaxer.jaddress.parser;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.GradleStructure;
import org.unlaxer.jaddress.ProjectContext;
import org.unlaxer.jaddress.SubProjects;
import org.unlaxer.util.function.Unchecked;

public class BlockSeparatorDefinition{
	static Set<BlockSeparator> separators ;
	static final  String FILE="blockSeparators.tsv";
	
	static {
		loadBlockSepartors();
	}
	
	static void loadBlockSepartors()  {
		Path path = ProjectContext.getPath(SubProjects.main, GradleStructure.mainResources , FILE);
		
		try(BufferedReader  reader = Unchecked.of(()->Files.newBufferedReader(path)).get();){
			separators = reader.lines()
					.map(tsv->{
						String[] split = tsv.split("\t");
						return new BlockSeparator(split[0], BlockSeparatorKind.valueOf(split[1]));
					})
					.collect(Collectors.toSet());
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}
}