package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.entity.zip.ZipBasedAddress;


public interface BuildingHierarchyResolver {
	
	public default BuildingHierarchyResolverResult resolve(AddressContext addressContext) {
		
		//郵便番号と丁目以降のElementを使用して建物以降の階層要素のリストを得る
		//第一段階として、graphDBからtreeを取得する
		
		郵便番号 zip = addressContext.zip();
		
		Map<階層要素 , AddressElement> 丁目以降枝番までBy階層要素 = addressContext.丁目以降枝番までAsMap();
		
		return resolve(zip, 丁目以降枝番までBy階層要素);
	}
	
	public BuildingHierarchyResolverResult resolve(郵便番号 zip  , Map<階層要素 , AddressElement> 丁目以降枝番までBy階層要素);
	
	public interface ZipResolver{
		
		//	郵便番号に対して２個以上の住所が引っかかる場合もある。
		//src/test/resources/multipleJyuusyoJPResults.txt を参照
		List<? extends ZipBasedAddress> selectZipBasedAddressesByZip(郵便番号 zip);
		
		Stream<? extends ZipBasedAddress> selectZipBasedAddresses();
		
	}
}