package org.unlaxer.jaddress.parser;

import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.util.collection.Comparators;

public class BuildingHierarchyResolverResult{
	
	final SortedMap<階層要素, CharacterKinds> characterKindsBy階層要素;
	
	final SortedSet<String> buildingNames;
	
	public BuildingHierarchyResolverResult(SortedMap<階層要素, CharacterKinds> characterKindsBy階層要素, Set<String> buildingNames) {
		super();
		this.characterKindsBy階層要素 = characterKindsBy階層要素;
		this.buildingNames = new TreeSet<String>(Comparators.longerIsFirst);
		this.buildingNames.addAll(buildingNames);
	}
	
	public BuildingHierarchyResolverResult(SortedMap<階層要素, CharacterKinds> characterKindsBy階層要素) {
		super();
		this.characterKindsBy階層要素 = characterKindsBy階層要素;
		this.buildingNames = new TreeSet<String>();
	}
	
	public String toString() {
		return new StringJoiner(",", "{", "}")
				.add("characterKindsBy階層要素:'" + characterKindsBy階層要素.entrySet().stream()
						.map(s -> s.getKey().name() + ":" + s.getValue().toString())
						.collect(Collectors.joining(",", "[", "]")))
				.add("buildingNames:"
						+ buildingNames.stream().map(x -> "'" + x + "'").collect(Collectors.joining(",", "[", "]")))
				.toString();
	}
	
	public SortedMap<階層要素, CharacterKinds> characterKindsBy階層要素(){
		return characterKindsBy階層要素;
	}
	
	public SortedSet<String> buildingNames(){
		return buildingNames;
	}

}