package org.unlaxer.jaddress.parser;

import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import org.unlaxer.util.collection.Comparators;

public class BuildingNameSplitter{
	
	public static Optional<TripletAddressToken> split(
			AddressToken afterBlock , 
			BuildingHierarchyResolverResult buildingHierarchyResolverResult) {
		return split(afterBlock, buildingHierarchyResolverResult.buildingNames);
	}
	
	static Optional<TripletAddressToken> split(
			AddressToken afterBlock , 
			Set<String> buildingNames) {
		
		if(false == buildingNames instanceof SortedSet) {
			SortedSet<String> sortedSet = new TreeSet<String>(Comparators.longerIsFirst);
			sortedSet.addAll(buildingNames);
			buildingNames = sortedSet;
		}
		
		for (String buildingName : buildingNames) {
			
			StringIndex indexOf = afterBlock.indexOf(buildingName);
			
			if(indexOf.value != -1) {
	
				return Optional.of(
					new TripletAddressToken(
						afterBlock,
						indexOf ,
						buildingName.length(),
						SeparatorKind.domainSpecificSeparator,
						SeparatorKind.domainSpecificSeparator
					)
				);
			}
		}
		return Optional.empty();
	}
}