package org.unlaxer.jaddress.parser;

import java.lang.Character.UnicodeBlock;

public class CodePointAndCharacterKind{
	
	final int codePoint;
	final CharacterKind characterKind;
	final UnicodeBlock unicodeBlock;
	
	public CodePointAndCharacterKind(CharacterKind characterKind , int codePoint) {
		super();
		this.codePoint = codePoint;
		this.characterKind = characterKind;
		unicodeBlock = UnicodeBlock.of(codePoint);
	}
	
	public CharacterKind characterKind() {
		return characterKind;
	}
	
	public int codePoint() {
		return codePoint;
	}
	
	public UnicodeBlock unicodeBlock() {
		return unicodeBlock;
	}

	@Override
	public String toString() {
		return characterKind + ":" + "\""+new String(new int[] {codePoint}, 0, 1) + "\"";
	}

	public CodePointAndCharacterKind as(CharacterKind newCharacterKind) {
		return new CodePointAndCharacterKind(newCharacterKind, codePoint);
	}
}