package org.unlaxer.jaddress.parser;

public class DebugStatus{
	
	public final ResolverResultHolder resolverResults;
	final String hyphonedHexes;
	
	public DebugStatus(ResolverResultHolder resolverResults) {
		super();
		this.resolverResults = resolverResults;
		this.hyphonedHexes = resolverResults.toString();
	}
	
	public DebugStatus(String hyphonedHexes) {
		super();
		this.hyphonedHexes = hyphonedHexes;
		this.resolverResults = ResolverResultHolder.fromHex(hyphonedHexes);
	}
	
	@Override
	public String toString() {
		return hyphonedHexes;
	}

	public ResolverResultHolder getResolverResults() {
		return resolverResults;
	}

	public String hyphonedHexes() {
		return hyphonedHexes;
	}
	
	public boolean hasParsingState(ParsingState parsingState) {
		
		boolean anyMatch = resolverResults.processedProcessor().stream()
			.anyMatch(resolverResult -> {
				ResolverResultKind kind = resolverResult.kind();
				ResolverResultKindOfProcessedProcessor processor = 
					ResolverResultKindOfProcessedProcessor.class.cast(kind);
				return processor.parsingState == parsingState;
			});
		
		return anyMatch;
	}
}