package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.stream.Collectors;

import io.vavr.collection.Stream;

public class DebugStatuses{
	
	//make public for JSONIC::encode
	public final List<DebugStatus> debugStatuses;
	final String underScoredDebugStatus;
	
	public DebugStatuses(String underScoredDebugStatus) {
		super();
		this.underScoredDebugStatus = underScoredDebugStatus;
		debugStatuses = from(underScoredDebugStatus);
	}

	
	public static List<DebugStatus> from(String underScoredDebugStatus){
		
		String[] degbugStatuses = underScoredDebugStatus.split("_");
		
		List<DebugStatus> collect = Stream.of(degbugStatuses)
			.map(DebugStatus::new)
			.collect(Collectors.toList());
		
		return collect;
	}
	
	public DebugStatuses(List<? extends ResolverResultHolder> partialParsingResults) {
		debugStatuses = partialParsingResults.stream()
			.map(DebugStatus::new)
			.collect(Collectors.toList());
		underScoredDebugStatus = toString(partialParsingResults);
	}

	public static String toString(List<? extends ResolverResultHolder> partialParsingResults) {
		
		return partialParsingResults.stream()
			.map(ResolverResultHolder::toHyphonedHexes)
			.collect(Collectors.joining("_"));
	}

	public List<DebugStatus> debugStatuses() {
		return debugStatuses;
	}

	public String underScoredDebugStatus() {
		return underScoredDebugStatus;
	}

	@Override
	public String toString() {
		return underScoredDebugStatus;
	}
	
	public boolean allMatchParsingState(ParsingState parsingState) {
		
		return debugStatuses.stream()
			.allMatch(debugStatus->debugStatus.hasParsingState(parsingState));
	}
	
	public boolean anyMatchParsingState(ParsingState parsingState) {
		
		return debugStatuses.stream()
			.anyMatch(debugStatus->debugStatus.hasParsingState(parsingState));
	}

}