package org.unlaxer.jaddress.parser;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.unlaxer.jaddress.entity.standard.OffsetOfBlock;
import org.unlaxer.jaddress.entity.standard.OffsetOfBuilding;
import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.standard.階層要素;

import io.vavr.Tuple2;

public class FlatResult{
	
	public final String input;
	public final 郵便番号 zip;
	public final Map<階層要素, String> valueBy階層要素 = new LinkedHashMap<>();
	public final Map<OffsetOfBlock, String> valueByOffsetOfBlock = new LinkedHashMap<>();
	public final Map<OffsetOfBuilding, String> valueByOffsetOfBuilding = new LinkedHashMap<>();
	
	public FlatResult(String input, 郵便番号 zip) {
		super();
		this.input = input;
		this.zip = zip;
		valueBy階層要素.put(階層要素.ZIP, zip.asHyphonated());
		valueBy階層要素.put(階層要素.全体, input);
	}
	
	public FlatResult add(階層要素 _階層要素, String value) {
		valueBy階層要素.put(_階層要素, value);
		return this;
	}
	
	public FlatResult add(OffsetOfBlock offsetOfBlock, String value) {
		valueByOffsetOfBlock.put(offsetOfBlock, value);
		return this;
	}
	
	public FlatResult add(OffsetOfBuilding offsetOfBuilding, String value) {
		valueByOffsetOfBuilding.put(offsetOfBuilding, value);
		return this;
	}
	
	public List<Tuple2<階層要素, String>> get(階層要素... 階層要素s){
		
		List<Tuple2<階層要素, String>> collect = Stream.of(階層要素s)
			.map(_階層要素->{
				String string = valueBy階層要素.get(_階層要素);
//				return string == null ? 
//					Optional.empty():
//					Optional.of(new Tuple2<階層要素, String>(_階層要素, string)); <- compile error on collect()
				return 
						new Tuple2<階層要素, Optional<String>>(_階層要素, Optional.ofNullable(string));

			})
			.filter(tuple->tuple._2().isPresent())
			.map(tuple-> new Tuple2<階層要素, String>(tuple._1(),tuple._2().get()))
			.collect(Collectors.toList());
			
		return collect;
	}
}