package org.unlaxer.jaddress.parser;

import org.unlaxer.jaddress.entity.standard.階層要素;

public class HeuristicBlockMatcher{
	
	public static boolean isMatch(ParsingTarget parsingTarget , TripletAddressToken triplet , 階層要素 _階層要素) {
		
		CharacterKinds characterKinds = new CharacterKinds(triplet.matched().stringAndCharacterKinds());
		
		String successor = triplet.successor().asString();
		if(characterKinds.isNumber() && 
				(successor.equals("号室"))){//||
				//successor.equals("号"))) {
			
			parsingTarget.addResolverResult(
				new ResolverResult(ResolverResultKindOfBoolean.Block要素中に号室を発見));
			return false;
		}
		
		if(triplet.predecessor().stringAndCharacterKinds().size()>1) {
			parsingTarget.addResolverResult(
				new ResolverResult(ResolverResultKindOfBoolean.Block要素の前段のCharacter種類が２個以上));
			return false;
		}
		
		if(triplet.predecessor().stringAndCharacterKinds().joined.length()>2) {
			parsingTarget.addResolverResult(
				new ResolverResult(ResolverResultKindOfBoolean.Block要素の前段の文字列が3文字以上));
			return false;
		}
		return true;
	}
}