package org.unlaxer.jaddress.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

import org.unlaxer.jaddress.entity.zip.ZipBasedAddress;
import org.unlaxer.jaddress.parser.processor.BlockHierarchyResolver.BlockPatternResolverResult;

public class IntermediateResultImpl implements IntermediateResult{
	
	BuildingHierarchyResolverResult buildingHierarchyResolverResult;
	
	BlockPatternResolverResult blockPatternResolverResult;
	
	List<? extends ZipBasedAddress> jyuusyoJpFromZip;
	
	Set<ResolverResultKind> resolverResultKinds;
	
	public IntermediateResultImpl() {
		super();
		resolverResultKinds = new HashSet<>();
	}

	@Override
	public SortedSet<String> buidingNames() {
		
		if(isBuildingHierarchyResolverResultPresent()) {
			return buildingHierarchyResolverResult.buildingNames;
		}
		return Collections.emptySortedSet();
	}

	@Override
	public void setZipBasedAddressesFromZip(List<? extends ZipBasedAddress> jyuusyoJpFromZip) {
		this.jyuusyoJpFromZip = jyuusyoJpFromZip;
	}

	@Override
	public void setBlockPatternResolverResult(BlockPatternResolverResult blockPatternResolverResult) {
		this.blockPatternResolverResult = blockPatternResolverResult;
	}

	@Override
	public BuildingHierarchyResolverResult buildingHierarchy() {
		return buildingHierarchyResolverResult;
	}

	@Override
	public BlockPatternResolverResult blockPatternResolverResult() {
		return blockPatternResolverResult;
	}

	@Override
	public boolean isBlockPatternResolverResultPresent() {
		return blockPatternResolverResult != null;
	}

	@Override
	public boolean isBuildingHierarchyResolverResultPresent() {
		return buildingHierarchyResolverResult != null;
	}

	@Override
	public boolean isZipBasedAddressesFromZipPresent() {
		return jyuusyoJpFromZip != null;
	}

	@Override
	public List<? extends ZipBasedAddress> zipBasedAddressesFromZip() {
		return jyuusyoJpFromZip;
	}

	@Override
	public void setBuildingHierarchyResolverResult(BuildingHierarchyResolverResult buildingHierarchyResolverResult) {
		this.buildingHierarchyResolverResult = buildingHierarchyResolverResult;
	}
}