package org.unlaxer.jaddress.parser;

import org.unlaxer.jaddress.model.IntegerValue;

public class ListIndex  extends IntegerValue{

	private static final long serialVersionUID = 2142036429340539893L;
	
	public ListIndex(int value) {
		super(value);
	}
	
	public static ListIndex of(int index) {
		return new ListIndex(index);
	}
	
	public ListIndex plus(int plus) {
		return new ListIndex(plus + value);
	}
	
	public boolean lessThan(ListIndex other) {
		return value < other.value;
	}
	
	public boolean lessThanEqual(ListIndex other) {
		return value <= other.value;
	}
	
	public boolean greaterThan(ListIndex other) {
		return value > other.value;
	}
	
	public boolean greaterThanEqual(ListIndex other) {
		return value >= other.value;
	}
}