package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.stream.Collectors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerContext{
	static Logger logger = LoggerFactory.getLogger("PARSER");
		
	public static void output(TargetStateAndElement targetStateAndElement) {
		logger.debug("state : {} / target : {}" , targetStateAndElement.targetState , targetStateAndElement.target階層要素);
	}
	
	public static void output(ParsingTargetImpl  parsingTargetImpl) {
		output(parsingTargetImpl.targetStateAndElement());
	}
	
	public static void addChild(AddressElement target , AddressElement child) {
		addChild(null, target, List.of(child));
	}
	
	public static void addChild(Integer index , AddressElement target , AddressElement child) {
		addChild(index, target, List.of(child));
	}

	public static void addChild(AddressElement target , List<AddressElement> children) {
		addChild(null, target , children);
	}

	public static void addChild(Integer index , AddressElement target , List<AddressElement> children) {
		logger.debug("add element index : {} / target : {} / child: {}" ,
			index == null ? "last" : String.valueOf(index) , 
			target.toString(), 
			toString(children)
		);
	}
	
	static String  toString(List<AddressElement> children) {
		String collect = children.stream()
			.map(AddressElement::toString)
			.collect(Collectors.joining(",", "[", "]"));
		return collect;
	}
	
	public boolean isDebugEnabled() {
		return logger.isDebugEnabled();
	}

	public static void debug(String format, Object... arguments) {
		logger.debug(format , arguments);
	}
}