package org.unlaxer.jaddress.parser;

import org.apache.commons.codec.binary.Hex;
import org.unlaxer.jaddress.parser.ResolverResult.ResolverResultValue;
import org.unlaxer.jaddress.parser.ResolverResult.ResolverResultValueCodec;
import org.unlaxer.util.function.Unchecked;

public enum MatchKind implements ResolverResultValue{
	Match("完全一致"),
	NormalizedMatch("正規化後完全一致"),
	PrefixMatch("前方一致"),
	SuffixMatch("後方一致"),
	PartialMatch("部分一致"),
	FuzzyMatch("あいまい一致"),
	NoMatch("不一致"),
	;
	
	public final String description;

	private MatchKind(String description) {
		this.description = description;
	}
	
	public boolean partialMatched() {
		return 
				this == PrefixMatch ||
				this == SuffixMatch ||
				this == PartialMatch;
	}
	
	public boolean fullMatched() {
		return 
//					this == FuzzyMatch || 
				this == Match ||
				this == NormalizedMatch ;
	}
	
	public boolean isMatched() {
		return false == (this == NoMatch);
	}
	
	public boolean isNotMatched() {
		return this == NoMatch;
	}
	
	static class M{
		public static void main(String[] args) {
			
			for (int i = 0; i < 20; i++) {
				System.out.println(Integer.toHexString(i));
			}
		}
	}

	
	public static class MatchKindCodec implements ResolverResultValueCodec<MatchKind>{

		@Override
		public MatchKind decode(String encodedString) {
			byte[] decodeHex = Unchecked.supplier(()->Hex.decodeHex("0" + encodedString)).get();
			int ordinal = decodeHex[0] - 1;
			return MatchKind.values()[ordinal];
		}
		
		
		@Override
		public String encode(MatchKind resolverResultValue) {
			String nibble = Unchecked.supplier(()->Hex.encodeHexString(new byte[] {(byte)(resolverResultValue.ordinal()+1)})).get().substring(1);
			return nibble;
		}
	
	}
}