package org.unlaxer.jaddress.parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class MultiCharacterFastMapper {

	public static class Tuple {
		public Tuple(String key, String value) {
			this.key = key;
			this.value = value;
			this.length = key.length();
		}

		public String key;
		public String value;
		public int length;
	}

	public static class Tuples {
		public final SortedMap<Integer, List<MultiCharacterFastMapper.Tuple>> tuplesByLength = //
		new TreeMap<Integer, List<MultiCharacterFastMapper.Tuple>>(Collections.reverseOrder());

		public boolean hasMultiCharacter;

		public void add(MultiCharacterFastMapper.Tuple tuple) {
			if (tuple.length > 1) {
				hasMultiCharacter = true;
			}
			List<MultiCharacterFastMapper.Tuple> list = tuplesByLength.get(tuple.length);
			if (list == null) {
				list = new ArrayList<MultiCharacterFastMapper.Tuple>();
				tuplesByLength.put(tuple.length, list);
			}
			list.add(tuple);
		}

		public String getMatched(String key) {
			List<MultiCharacterFastMapper.Tuple> list = tuplesByLength.get(key.length());
			if (list == null) {
				return null;
			}
			for (MultiCharacterFastMapper.Tuple tuple : list) {
				if (tuple.key.equals(key)) {
					return tuple.value;
				}
			}
			return null;
		}

		public Set<Integer> getLengths() {
			return tuplesByLength.keySet();
		}
	}

	MultiCharacterFastMapper.Tuples[] TuplesArray = new MultiCharacterFastMapper.Tuples[65536];

	public MultiCharacterFastMapper(Map<String, String> replacedByKey) {

		for (Entry<String, String> entry : replacedByKey.entrySet()) {
			int index = entry.getKey().charAt(0) - Character.MIN_VALUE;
			MultiCharacterFastMapper.Tuples tuples = TuplesArray[index];
			if (tuples == null) {
				tuples = new Tuples();
				TuplesArray[index] = tuples;
			}
			tuples.add(new Tuple(entry.getKey(), entry.getValue()));
		}
	}

	public String replace(String target) {
		int targetLength = target.length();
		StringBuilder builder = new StringBuilder(targetLength);

		for (int i = 0; i < targetLength; i++) {
			String substring = target.substring(i, i + 1);
			int index = substring.charAt(0) - Character.MIN_VALUE;
			MultiCharacterFastMapper.Tuples tuples = TuplesArray[index];
			if (tuples == null) {
				builder.append(substring);
				continue;
			}
			Set<Integer> lengths = tuples.getLengths();
			boolean appends = false;
			for (Integer keyLength : lengths) {
				if (i + keyLength > targetLength) {
					continue;
				}
				String key = target.substring(i, i + keyLength);
				String matched = tuples.getMatched(key);
				if (matched == null) {
					continue;
				}
				i += keyLength - 1;
				builder.append(matched);
				appends = true;
				break;
			}
			if(appends){
				continue;
			}
			builder.append(substring);
		}
		return builder.toString();
	}
}