package org.unlaxer.jaddress.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

import org.unlaxer.jaddress.entity.standard.IDHolder;
import org.unlaxer.jaddress.entity.standard.LevelHolder;
import org.unlaxer.jaddress.entity.standard.NameHolder;
import org.unlaxer.jaddress.entity.standard.OffsetHolder;
import org.unlaxer.jaddress.entity.standard.OffsetOfBlock;
import org.unlaxer.jaddress.entity.standard.OffsetOfBuilding;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.util.collection.ID;

public class MultipleAddressElement implements IDHolder , LevelHolder , OffsetHolder , NameHolder{
	
	SingleOrRange階層要素 _階層要素;
	List<AddressElement> elements;
	
	public Optional<OffsetOfBlock> offsetOfBlock = Optional.empty();
	public Optional<OffsetOfBuilding> offsetOfBuilding = Optional.empty();

	public MultipleAddressElement(AddressElement addressElement) {
		super();
		this.elements = new ArrayList<>();
		elements.add(addressElement);
		_階層要素 = addressElement._階層要素;
	}
	
	public List<AddressElement> get(){
		return elements;
	}
	
	public void add(AddressElement addressElement) {
		if(false == addressElement.singleOrRange階層要素().equals(_階層要素)) {
			throw new IllegalArgumentException();
		}
		elements.add(addressElement);
	}
	
	public SingleOrRange階層要素 階層要素() {
		return _階層要素;
	}

	@Override
	public String toString() {
		String collect = elements.stream()
				.map(AddressElement::toString)
				.map(x->"'"+x+"'")
				.collect(Collectors.joining(",", "[", "]"));
			return collect;
	}
	
	public List<AddressElement> elements(){
		return elements;
	}

	@Override
	public ID id() {
		return _階層要素.id();
	}

	@Override
	public String name() {
		return _階層要素.name();
	}

	@Override
	public int level() {
		return _階層要素.level();
	}
	
	@Override
	public Optional<OffsetOfBlock> offsetOfBlock() {
		return offsetOfBlock;
	}

	@Override
	public Optional<OffsetOfBuilding> offsetOfBuilding() {
		return offsetOfBuilding;
	}

	@Override
	public void setOffsetOfBlock(OffsetOfBlock offsetOfBlock) {
		this.offsetOfBlock = Optional.of(offsetOfBlock);
	}

	@Override
	public void setOffsetOfBuilding(OffsetOfBuilding offsetOfBuilding) {
		this.offsetOfBuilding= Optional.of(offsetOfBuilding);
	}
}