package org.unlaxer.jaddress.parser;

import static guru.nidi.graphviz.model.Factory.graph;
import static guru.nidi.graphviz.model.Factory.node;
import static guru.nidi.graphviz.model.Factory.to;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.SortedSet;

import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.Node;

public class MultipleAddressElementsRenderer implements AddressRenderer{
	
	public static void writeTo(String name , int width  ,SortedSet<MultipleAddressElement> addressElements , Path path) {
			
		Graphviz graphviz = toGraphviz(name, width, addressElements);
		try {
			graphviz.render(Format.PNG).toFile(path.toFile());
		} catch (IOException e) {
			throw new UncheckedIOException(e);
		}
	}
	
	public static Graphviz toGraphviz(
			String name , int width  ,SortedSet<MultipleAddressElement> addressElements) {
		
		Node root = node("result").with(Shape.CIRCLE , Color.BLACK);
		
		for(MultipleAddressElement addressElement :  addressElements) {
			Node node  = createNode(addressElement);
			
			root = root.link(to(node));
		}
		
		Graph g = graph(name).directed().with(root);
		Graphviz graphviz = Graphviz.fromGraph(g).width(width);
		
		return graphviz;
	}
		
	static Node createNode(MultipleAddressElement addressElement) {
		
		Node node = node("\"" + addressElement.階層要素() + "\"").with(Shape.RECTANGLE ,  Color.BLACK);
		for(AddressElement child : addressElement.elements) {
			
			Node childNode = node(Label.of(toString(child))).with(Shape.ELLIPSE ,  Color.BLACK);
			node = node.link(to(childNode));
		}
		return node;
	}
		
	static String toString(AddressElement addressElement) {
		
		String prefix = addressElement.prefix().map(x->"["+x+"]").orElse("");
		String suffix = addressElement.suffix().map(x->"["+x+"]").orElse("");
		
		return prefix +  addressElement.stringAndCharacterKinds.joined() + suffix; 
	}
}