package org.unlaxer.jaddress.parser;

import java.util.function.Function;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;

public interface NextStateResolverBy階層要素 extends Function<SingleOrRange階層要素, ParsingState>{

	@Override
	default ParsingState apply(SingleOrRange階層要素 _階層要素) {
		
		ParsingState parseingState = _階層要素.階層要素()
			.map(this::apply)
			.orElseGet(()-> 
					_階層要素.定義済みRange階層要素()
						.map(this::apply)
						.orElseThrow());
		return parseingState;
	}
	
	ParsingState apply(階層要素 _階層要素);
	
	ParsingState apply(定義済みRange階層要素 _階層要素);

}