package org.unlaxer.jaddress.parser;

import java.util.Optional;

public class NumberParser implements StringMatcher{

	@Override
	public TripletAddressToken match(AddressToken target) {
		
		return _match(target)
				.orElseGet(()->TripletAddressToken.empty(target));
	}

	private Optional<TripletAddressToken> _match(AddressToken addressToken) {
		int index = 0;
		
		CharacterKind matchedKind = null;
		
		for (StringAndCharacterKind stringAndCharacterKind : addressToken.stringAndCharacterKinds()) {
			
			if(stringAndCharacterKind.characterKind == CharacterKind.arabicNumber ||
				stringAndCharacterKind.characterKind == CharacterKind.japaneseAddressNumber ) {
					
					matchedKind = stringAndCharacterKind.characterKind;
					break;
			}
			index++;
		}
		
		if(matchedKind == null) {
			return Optional.empty();
		}
		
		TripletAddressToken triplet = new TripletAddressToken(
			addressToken,
			addressToken.subList(ListIndex.of(0), ListIndex.of(index) , 
					addressToken.separatorKindOfLeading() , SeparatorKind.domainSpecificSeparator),
			addressToken.subList(ListIndex.of(index), ListIndex.of(index+1) ,
					SeparatorKind.domainSpecificSeparator , SeparatorKind.domainSpecificSeparator),
			addressToken.subList(ListIndex.of(index+1), ListIndex.of(addressToken.stringAndCharacterKinds().size()) , 
					SeparatorKind.domainSpecificSeparator , addressToken.separatorKindOfTailing())
		);
		
		return Optional.of(triplet);
	}

	@Override
	public TripletAddressToken matchWithSuccessor(TripletAddressToken tripletAddressToken) {
		
		AddressToken successorToken = tripletAddressToken.successor();
		
		return match(successorToken);
	}
	
}