package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.unlaxer.jaddress.entity.standard.IDHolder;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.util.collection.ID;
import org.unlaxer.util.collection.TreeNode;
import org.unlaxer.util.collection.TreeNodeList;

public interface OverAllAddressContext extends AddressContext{

	@Override
	default Kind kind() {
		return Kind.overAllAddresses;
	}
	
	public static OverAllAddressContext of(AddressContext addressContext) {
		
		if(false == addressContext.kind().isOverAll()) {
			throw new IllegalArgumentException();
		}
		
		return new OverAllAddressContext() {
			
			@Override
			public ID id() {
				return addressContext.id();
			}
			
			@Override
			public Map<階層要素, AddressElement> 丁目以降枝番までAsMap() {
				return addressContext.丁目以降枝番までAsMap();
			}
			
			@Override
			public List<AddressElement> 丁目以降枝番までAsList() {
				return addressContext.丁目以降枝番までAsList();
			}
			
			@Override
			public 郵便番号 zip() {
				return addressContext.zip();
			}
			
			@Override
			public TreeNodeList<AddressElement> split(TreeNode<AddressElement> targetNode, SeparatorWithKind separatorWithKind,
					SplitStrategy splitStrategy, SingleOrRange階層要素... elementKinds) {
				return addressContext.split(targetNode, separatorWithKind, splitStrategy, elementKinds);
			}
			
			@Override
			public PickerResults pickerResults() {
				return addressContext.pickerResults();
			}
			
			@Override
			public Optional<TreeNode<AddressElement>> find(IDHolder hierarchyElement) {
				return addressContext.find(hierarchyElement);
			}
			
			@Override
			public TreeNode<AddressElement> addressTree() {
				return addressContext.addressTree();
			}
			
			@Override
			public StringAndCharacterKinds addressString() {
				return addressContext.addressString();
			}
			
			@Override
			public void addChildren(TreeNode<AddressElement> target, TreeNodeList<AddressElement> children) {
				addressContext.addChildren(target, children);
			}
			
			@Override
			public void addChild(int index, TreeNode<AddressElement> target, AddressElement child) {
				addressContext.addChild(target, child);
			}
			
			@Override
			public void addChild(TreeNode<AddressElement> target, AddressElement child) {
				addressContext.addChild(target, child);
			}
			
			@Override
			public void addChild(TreeNode<AddressElement> target, TreeNode<AddressElement> child) {
				addressContext.addChild(target, child);
			}

			@Override
			public List<AddressElement> originalAddresses() {
				return addressContext.originalAddresses();
			}
		};
	}
}