package org.unlaxer.jaddress.parser;

import java.util.Optional;

import org.unlaxer.Range;
import org.unlaxer.jaddress.entity.standard.詳細住所;

public class ParsedResult{
	
	final ParsedResult.Status status;
	
	final 詳細住所 current;
	
	final Range consumed;
	
	final float score;
	
	public enum Status{
		OK,
		郵便番号住所なし,
		郵便番号取得住所マッチしない,
		パラメータエラー,
		
	}
	
	public ParsedResult(ParsedResult.Status status , 詳細住所 result , Range consumed  , float score) {
		super();
		this.status = status;
		this.current = result;
		this.consumed = consumed;
		this.score = score;
	}

	public final Optional<詳細住所> result() {
		return Optional.ofNullable(current);
	}
	
	public ParsedResult.Status status() {
		return status;
	}
	
	public float score() {
		return score;
	}
}