package org.unlaxer.jaddress.parser;

import java.util.List;

import org.unlaxer.jaddress.PoisonPillEnabler;
import org.unlaxer.jaddress.entity.standard.IDHolder;
import org.unlaxer.jaddress.entity.standard.郵便番号;
import org.unlaxer.util.collection.ID;

public interface ParsingContext extends ParsingContextHolder , ParsingTargetsHolder , IDHolder , 
	OverAllAddressContextHolder  , PoisonPillEnabler{
	
	public static ParsingContext create(ID id , OverAllAddressContext overAllAddressContext, DataAccessContext dataAccessContext) {
		
		ParsingContext parsingContext = new ParsingContextImpl(id , overAllAddressContext, dataAccessContext);
		return parsingContext;
	}
	
	public static ParsingContext create(
			ID id , OverAllAddressContext overAllAddressContext, 
			DataAccessContext dataAccessContext , IntermediateResult intermediateResult) {
		
		ParsingContext parsingContext = 
				new ParsingContextImpl(id , overAllAddressContext , dataAccessContext , intermediateResult);
		return parsingContext;
	}
	
	public static ParsingContext create(
			List<AddressElement> addresses  , 
			ID id , 
			郵便番号 zip , 
			DataAccessContext  dataAccessContext) {
		
		OverAllAddressContext addressContext = OverAllAddressContext.of(
			AddressContext.createOverAll(zip, addresses)
		);
		ParsingContext parsingContext = ParsingContext.create(id , addressContext , dataAccessContext);
		
		return parsingContext;
	}

	
}