package org.unlaxer.jaddress.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.unlaxer.util.collection.ID;

public class ParsingContextImpl implements ParsingContext {

	final ID id;
	
	final List<ParsingTarget> parsingTargets;
	
	final IntermediateResult intermediateResult;
	
	final DataAccessContext dataAccessContext;
	
	final OverAllAddressContext overAllAddressContext;
	
	final Map<ID, Boolean> enabledByID;

	public ParsingContextImpl(OverAllAddressContext overAllAddressContext ,DataAccessContext dataAccessContext) {
		this(ID.generate() , overAllAddressContext , dataAccessContext, new IntermediateResultImpl());
	}
	
	public ParsingContextImpl(ID id , OverAllAddressContext overAllAddressContext , DataAccessContext dataAccessContext) {
		this(id , overAllAddressContext ,  dataAccessContext, IntermediateResult.create());
	}
	
	public ParsingContextImpl(ID id , OverAllAddressContext overAllAddressContext , 
			DataAccessContext dataAccessContext , IntermediateResult intermediateResult) {
		this.overAllAddressContext = overAllAddressContext;
		this.id = id;
		this.dataAccessContext = dataAccessContext;
		this.intermediateResult = intermediateResult;
		parsingTargets = new ArrayList<>();
		enabledByID = new HashMap<ID, Boolean>();
	}
	
	@Override
	public List<ParsingTarget> parsingTargets(){
		return parsingTargets;
	}

	@Override
	public IntermediateResult intermediateResult() {
		return intermediateResult;
	}
	
	@Override
	public void addParsingTarget(ParsingTarget parsingTarget) {
		parsingTargets.add(parsingTarget);
	}

	@Override
	public DataAccessContext dataAccessContext() {
		return dataAccessContext;
	}

	@Override
	public ID id() {
		return id;
	}

	@Override
	public OverAllAddressContext overAllAddressContext() {
		return overAllAddressContext;
	}

	@Override
	public Map<ID, Boolean> enabledByID() {
		return enabledByID;
	}
}