package org.unlaxer.jaddress.parser;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;

import org.unlaxer.jaddress.entity.standard.郵便番号;

public interface ParsingResult {
	
	List<PartialParsingResult> partialParsingResults();
	AddressElements addressElementsWithoutCheck();
	
	default Optional<AddressElements> addressElements(){
		return isValid() ? 
			Optional.of(addressElementsWithoutCheck()) :
			Optional.empty();
	}
	
	boolean isValid();
	
	public default 郵便番号 zip() {
		return overAllAddressContext().zip();
	}
	
	public default StringAndCharacterKinds inputAddress() {
		return overAllAddressContext().addressString();
	}
	
	OverAllAddressContext overAllAddressContext();
	
	public static ParsingResult create(OverAllAddressContext addressContext , List<PartialParsingResult> partialParsingResults) {
		return new ParsingResultImpl(addressContext, partialParsingResults);
	}
	
	public static ParsingResult create(OverAllAddressContext addressContext , PartialParsingResult... partialParsingResults) {
		return new ParsingResultImpl(addressContext , List.of(partialParsingResults));
	}
	
	default AddressElements createAddressElements() {
		
		List<PartialParsingResult> partialParsingResults = partialParsingResults();
		
		PartialParsingResult partialParsingResult = partialParsingResults.get(0);
		
		AddressElements baseResult = partialParsingResult.result()
			.orElseGet(()->{
				
				AddressContext addressContext = partialParsingResult.parsingTarget().addressContext();
				return new AddressElements(addressContext);
			});
		
		Iterator<PartialParsingResult> iterator = partialParsingResults.iterator();
		
		iterator.next();
		
		while (iterator.hasNext()) {
			PartialParsingResult additionalParsingResult = iterator.next();
			if(false == additionalParsingResult.parsingState().equals(ParsingState.パース終了)) {
				continue;
			}
			additionalParsingResult.result().ifPresent(baseResult::overWrite);
		}
		
		return baseResult;
	}
	
	public default String resolverResultsAsHex() {
		return DebugStatuses.toString(partialParsingResults());
	}
	
	FlatResult flatResult();
	
//	public Map<String,String> resultAsMap();
}