package org.unlaxer.jaddress.parser;

import java.util.List;

import io.vavr.Lazy;

public class ParsingResultImpl implements ParsingResult{
	
	static ResultRegulator resultRegulator = new ResultRegulator();
	
	final List<PartialParsingResult> partialParsingResults;
	final AddressElements addressElements; 
	final boolean isValid;
	final OverAllAddressContext overAllAddressContext;
	final Lazy<FlatResult> flatResult = Lazy.of(()->resultRegulator.create(this));

	public ParsingResultImpl(OverAllAddressContext overAllAddressContext , List<PartialParsingResult> partialParsingResults) {
		super();
		this.overAllAddressContext = overAllAddressContext;
		this.partialParsingResults = partialParsingResults;
		addressElements = createAddressElements();
		isValid = partialParsingResults.stream()
			.map(PartialParsingResult::parsingState)
			.allMatch(ParsingState::isSuccess);

	}

	@Override
	public List<PartialParsingResult> partialParsingResults() {
		return partialParsingResults;
	}


	@Override
	public AddressElements addressElementsWithoutCheck() {
		return addressElements;
	}

	@Override
	public boolean isValid() {
		return isValid;
	}

	@Override
	public OverAllAddressContext overAllAddressContext() {
		return overAllAddressContext;
	}

	@Override
	public FlatResult flatResult() {
		return flatResult.get();
	}
}