package org.unlaxer.jaddress.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.unlaxer.jaddress.PoisonPill;
import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.util.collection.ID;

public class ParsingTargetImpl implements ParsingTarget{

	final ParsingContext parsingContext;
	final AddressContext addressContext;

	TargetStateAndElement targetStateAndElement;
	
	PartialParsingResult partialParsingResult;
	
	Set<ResolverResult> resolverResults;
	
	AddressElements addressElements;
	
	Map<ID,PoisonPill> poisonPillByID = new HashMap<>();
	
	public ParsingTargetImpl(
			ParsingContext parsingContext,
			AddressContext addressContext) {
		
		this(parsingContext , addressContext,
			new TargetStateAndElement(
				ParsingState.ZIPから郵便番号情報取得,
				SingleOrRange階層要素.of(定義済みRange階層要素.全体)
			)
		);
	}
	
	public ParsingTargetImpl(
			ParsingContext parsingContext,
			AddressContext addressContext, 
			TargetStateAndElement targetStateAndElement) {
		
		super();
		this.parsingContext = parsingContext;
		this.addressContext = addressContext;
		setTargetStateAndElement(targetStateAndElement);
		resolverResults = new HashSet<>();
	}

	@Override
	public AddressContext addressContext() {
		return addressContext;
	}

	@Override
	public void setTargetStateAndElement(TargetStateAndElement targetStateAndElement) {
		TargetStateAndElement oldProcessResult = targetStateAndElement;

		this.targetStateAndElement = targetStateAndElement;
		LoggerContext.output(targetStateAndElement);
		
		if(oldProcessResult != null && 
			oldProcessResult.targetState.canTransit(targetStateAndElement.targetState)) {
			
			throw new IllegalStateException();
		}
	}

	@Override
	public TargetStateAndElement targetStateAndElement() {
		return targetStateAndElement;
	}

	@Override
	public IntermediateResult intermediateResult() {
		return parsingContext.intermediateResult();
	}

	@Override
	public DataAccessContext dataAccessContext() {
		return parsingContext.dataAccessContext();
	}

	@Override
	public PartialParsingResult partialParsingResult() {
		
		if(addressElements == null){
//			throw new IllegalStateException();
			partialParsingResult = PartialParsingResult.create(this , targetState());
		}
		if(partialParsingResult == null) {
			partialParsingResult = PartialParsingResult.create(this , targetState() , addressElements );
		}
		return partialParsingResult;
	}

	@Override
	public void addResolverResult(ResolverResult resolverResult) {
		resolverResults.add(resolverResult);
	}

	@Override
	public Set<ResolverResult> resolverResults() {
		return resolverResults;
	}

	@Override
	public AddressElements addressElements() {
		return addressElements;
	}

	@Override
	public void setAddressElements(AddressElements addressElements) {
		this.addressElements = addressElements;
	}

	@Override
	public Map<ID, PoisonPill> poisonPillByID() {
		return poisonPillByID;
	}
}