package org.unlaxer.jaddress.parser;

import java.util.Optional;

public interface PartialParsingResult extends ParsingStateHolder , ResolverResultHolder , ParsingTargetHolder{
	
	public void set(AddressElements addressElements);
	public Optional<AddressElements> result();
	
	public static PartialParsingResult create(ParsingTarget parsingTarget) {
		return new PartialParsingResultImpl(parsingTarget);
	}
	
	public static PartialParsingResult create(ParsingTarget parsingTarget , 
			ParsingState parsingState) {
		PartialParsingResult partialParsingResult = new PartialParsingResultImpl(parsingTarget);
		partialParsingResult.set(parsingState);
		return partialParsingResult;
	}
	
	public static PartialParsingResult create(ParsingTarget parsingTarget ,   
			ParsingState parsingState , AddressElements addressElements) {
		PartialParsingResult partialParsingResult = new PartialParsingResultImpl(parsingTarget , addressElements);
		partialParsingResult.set(parsingState);
		return partialParsingResult;
	}
}