package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.Optional;

import javax.annotation.Nullable;

public class PartialParsingResultImpl implements PartialParsingResult{
	
	private ParsingState parsingState;
	ResolverResultHolder resolverResultHolder;
	private Optional<AddressElements> result;
	private final ParsingTarget parsingTarget;
	
	public PartialParsingResultImpl(ParsingTarget parsingTarget) {
		this(parsingTarget , null);
	}
	public PartialParsingResultImpl(ParsingTarget parsingTarget ,@Nullable AddressElements addressElements) {
		super();
		this.parsingTarget = parsingTarget;
		parsingState = ParsingState.パース開始;
		this.result  = Optional.ofNullable(addressElements);
		resolverResultHolder = new ResolverResults();
		parsingTarget.resolverResults().stream().forEach(this::add);
	}

	@Override
	public ParsingState parsingState() {
		return parsingState;
	}

	@Override
	public void add(ResolverResult resolverResult) {
		resolverResultHolder.add(resolverResult);
	}

	@Override
	public void set(ParsingState parsingState) {
		this.parsingState = parsingState;
	}

	@Override
	public Optional<AddressElements> result() {
		return result;
	}
	@Override
	public void set(AddressElements addressElements) {
		
		result = Optional.ofNullable(addressElements);
	}
	@Override
	public ParsingTarget parsingTarget() {
		return parsingTarget;
	}
	@Override
	public List<ResolverResult> processedProcessor() {
		return resolverResultHolder.processedProcessor();
	}
	@Override
	public List<ResolverResult> processed() {
		return resolverResultHolder.processed();
	}
	@Override
	public List<ResolverResult> matched() {
		return resolverResultHolder.matched();
	}
}