package org.unlaxer.jaddress.parser;

import java.util.List;
import java.util.Optional;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.entity.standard.定義済みRange階層要素;
import org.unlaxer.jaddress.entity.standard.階層要素;
import org.unlaxer.jaddress.parser.PickerResults.PredecessorOrSuccessor;
import org.unlaxer.jaddress.parser.picker.PickerResult;
import org.unlaxer.jaddress.parser.picker.ValueAndSuffixPicker;
import org.unlaxer.util.collection.TreeNode;

import io.vavr.Tuple3;

public interface PickerParer{
	
	public enum Pick{
		withSuffix,
		withoutSuffix,
		;
		public boolean withSuffix() {
			return this == withSuffix;
		}
		public boolean withoutSuffix() {
			return this == withoutSuffix;
		}
	}
	
	public enum AfterAction{
		addResultToAddressContext,
		nothing
		;
	}
	
	public default  Optional<PickerResult> parse(
			ParsingTarget parsingTarget,
			Pick pickWith,
			AfterAction afterAction){
		
		AddressContext addressContext = parsingTarget.addressContext();
		PickerResults pickerResults = addressContext.pickerResults();
		
		List<Tuple3<PredecessorOrSuccessor, SingleOrRange階層要素, AddressToken>> 
			targetTokens = targetTokens(pickerResults);
		for (Tuple3<PredecessorOrSuccessor, SingleOrRange階層要素, AddressToken> tuple3 : targetTokens) {
			
			PredecessorOrSuccessor predecessorOrSuccessor  = tuple3._1();
			SingleOrRange階層要素 _階層要素 = tuple3._2();
			AddressToken source = tuple3._3();
			
			Optional<PickerResult> parsed = parse(parsingTarget , source , pickWith , afterAction);
			
			parsed.ifPresent(result->{
				pickerResults.remove(_階層要素, predecessorOrSuccessor);
				pickerResults.add(parsed);
			});
			
			if(parsed.isPresent()) {
				return parsed;
			}
		}
		return Optional.empty();
	}
	
	public default SingleOrRange階層要素 pickupFrom(AddressContext addressContext) {
		
		Optional<TreeNode<AddressElement>> find = addressContext.find(定義済みRange階層要素.建物より後);
		
		return find.isPresent() ?  
				SingleOrRange階層要素.of(定義済みRange階層要素.建物より後) : 
				SingleOrRange階層要素.of(定義済みRange階層要素.建物以降);
	}
	
	public default  Optional<PickerResult> parse(
			ParsingTarget parsingTarget,
			AddressToken source , 
			Pick pickWith,
			AfterAction  afterAction) {
		
		AddressContext addressContext = parsingTarget.addressContext();
		
		TreeNode<AddressElement> 建物以降Node =
				addressContext.addressTree().find(pickupFrom(addressContext).id()).orElseThrow();
		
		ValueAndSuffixPicker picker = picker();
		
			
		Optional<PickerResult> pick =
				pickWith.withSuffix() ? 
					picker.pick(source):
					picker.pickWithoutSuffix(source);
		
		pick.ifPresent(pickerResult->{
			
			AddressElement addressElement = 
					AddressElementFactory.of(pickerResult.value(), output階層要素());
			
			if(pickerResult.suffix().isPresent()) {
				addressElement.setSuffix(pickerResult.suffix().asString());
			}
			if(afterAction == AfterAction.addResultToAddressContext) {
				addChild(addressContext, 建物以降Node, addressElement);
			}
		});
		return pick;
	}
	
	public void addChild(AddressContext addressContext , TreeNode<AddressElement> target , AddressElement child);
	
	public 階層要素 output階層要素();
	public ValueAndSuffixPicker picker();
	
	public List<Tuple3<PredecessorOrSuccessor,SingleOrRange階層要素 , AddressToken>> targetTokens(PickerResults pickerResults);
	
	static void setTokenWithSuccessor(
			SingleOrRange階層要素 condition,
			List<Tuple3<PredecessorOrSuccessor, SingleOrRange階層要素, AddressToken>> results,
			SingleOrRange階層要素 _階層要素, AddressToken addressToken
			) {
		
		if(isInvalid(addressToken)) {
			return;
		}
		
		if(_階層要素.equals(condition)) {
			results.add(
				new Tuple3<>(
					PredecessorOrSuccessor.successor , 
					condition,
					addressToken
				)
			);
		}
	}
	
	static void setTokenWithPredecessor(
			SingleOrRange階層要素 condition,
			List<Tuple3<PredecessorOrSuccessor, SingleOrRange階層要素, AddressToken>> results,
			SingleOrRange階層要素 _階層要素, AddressToken addressToken
			) {
		
		if(isInvalid(addressToken)) {
			return;
		}
		
		if(_階層要素.equals(condition)) {
			results.add(
				new Tuple3<>(
					PredecessorOrSuccessor.predecessor , 
					condition,
					addressToken
				)
			);
		}
	}
	
	static boolean isInvalid(AddressToken addressToken) {
		String asString = addressToken.asString();
		return asString.isBlank();
	}
}