package org.unlaxer.jaddress.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;
import java.util.Set;

import org.unlaxer.jaddress.entity.standard.SingleOrRange階層要素;
import org.unlaxer.jaddress.parser.picker.PickerResult;

public class PickerResults{
	
	Map<SingleOrRange階層要素,AddressToken> sourcesByKindForPredecessor;//pickerでpickした値の前段Token By 階層要素
	Map<SingleOrRange階層要素,AddressToken> sourcesByKindForSuccessor;//pickerでpickした値の後段Token By 階層要素
	Map<SingleOrRange階層要素,PickerResult> pickerResultByKind;//pickerでpickした値 By階層要素


	public PickerResults() {
		super();
		sourcesByKindForPredecessor = new HashMap<>();
		sourcesByKindForSuccessor = new HashMap<>();
		pickerResultByKind = new HashMap<>();
	}
	
	public void add(Optional<PickerResult> parserResult) {
		
		parserResult.ifPresent(result->{
			
			SingleOrRange階層要素 _階層要素 = result.SingleOrRange階層要素();
			
			pickerResultByKind.put(_階層要素, result);
			
			result.predecessor().ifPresent(
					source->sourcesByKindForPredecessor.put(_階層要素, source));
			
			result.successor().ifPresent(
					source->sourcesByKindForSuccessor.put(_階層要素, source));
		});
	}
	
	public Map<SingleOrRange階層要素,AddressToken> get(PickerResults.PredecessorOrSuccessor predecessorOrSuccessor){
		return predecessorOrSuccessor.isPredecessor() ? 
				sourcesByKindForPredecessor:
				sourcesByKindForSuccessor;
	}

	public Optional<PickerResult> pickerResult(SingleOrRange階層要素 _階層要素){

		Optional<PickerResult> ofNullable = Optional.ofNullable(pickerResultByKind.get(_階層要素));
		return ofNullable;
	}
	
	public void add(
			SingleOrRange階層要素 _階層要素 ,
			PickerResults.PredecessorOrSuccessor predecessorOrSuccessor , 
			AddressToken addressToken) {
		
		Map<SingleOrRange階層要素 , AddressToken> map = get(predecessorOrSuccessor);
		
		map.put(_階層要素, addressToken);
	}
	
	public enum PredecessorOrSuccessor{
		predecessor,
		successor,
		;
		public boolean isPredecessor() {
			return this == predecessor;
		}
		public boolean isSuccessor() {
			return this == successor;
		}
	}
	
	public void remove(SingleOrRange階層要素 _階層要素 , PickerResults.PredecessorOrSuccessor predecessorOrSuccessor) {
		
		Map<SingleOrRange階層要素, AddressToken> map = get(predecessorOrSuccessor);
		
		map.remove(_階層要素);
	}
	
	public Optional<AddressToken> get(
			SingleOrRange階層要素 _階層要素 , PickerResults.PredecessorOrSuccessor predecessorOrSuccessor){
		
		Map<SingleOrRange階層要素, AddressToken> sourceByKind  = get(predecessorOrSuccessor);
		
		return Optional.ofNullable(sourceByKind.get(_階層要素));
	}
	
	public Set<Entry<SingleOrRange階層要素, AddressToken>> getAll(
			PickerResults.PredecessorOrSuccessor predecessorOrSuccessor) {
		return get(predecessorOrSuccessor).entrySet();
	}
}