package org.unlaxer.jaddress.parser;

import java.util.stream.IntStream;

public class RangeBothInclusive{
		
	public final int startInclusive;
	public final int endInclusive;
	public RangeBothInclusive(int startInclusive, int endInclusive) {
		super();
		this.startInclusive = startInclusive;
		this.endInclusive = endInclusive;
	}
	
	public boolean in(int target){
		
		return startInclusive <= target && target <= endInclusive;
	}
	
	public IntStream stream(){
		return 	IntStream.range(startInclusive, endInclusive+1);
	}
}