package org.unlaxer.jaddress.parser;

import org.unlaxer.jaddress.parser.processor.BlockHierarchyResolver.BlockPatternResolver;
import org.unlaxer.jaddress.parser.processor.BlockHierarchyResolver.SimpleBlockPatternResolver;

import io.vavr.Lazy;

public interface ResolverContext{
	
	static Lazy<BlockPatternResolver> blockPatternResolver = Lazy.of(SimpleBlockPatternResolver::new);
	static Lazy<BuildingHierarchyResolver> buildingHierarchyResolver = Lazy.of(SimpleBuildingHierarchyResolver::new);
	
	public BlockPatternResolver getBlockPatternResolver();
	public void setBlockPatternResolver(BlockPatternResolver blockPatternResolver);

	public BuildingHierarchyResolver getBuildingHierarchyResolver();
	public void setBuildingHierarchyResolver(BuildingHierarchyResolver buildingHierarchyResolver);

}