package org.unlaxer.jaddress.parser;

public class ResolverResult{
	
	public interface ResolverResultValue{
		
		String name();
		int ordinal();
		
//		public String encode();
//		public ResolverResultValue decode(String encodedString);
	}
	
	public interface ResolverResultValueCodec<T extends ResolverResultValue>{
		
		public String encode(T ResolverResultValue);
		public T decode(String encodedString);
	}
	
	public ResolverResultKind kind;
	public ResolverResultValue value;
	
	public ResolverResultKind kind() {
		return kind;
	}
	public ResolverResultValue value() {
		return value;
	}
	
	
	public ResolverResult(ResolverResultKind kind) {
		this(kind , null);
	}
	
	public ResolverResult(ResolverResultKind kind, ResolverResultValue value) {
		super();
		this.kind = kind;
		this.value = value;
//		bitSize = value == null ?
//			1:
//			Integer.toBinaryString(value.getDeclaringClass().getEnumConstants().length-1).length();
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((kind == null) ? 0 : kind.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ResolverResult other = (ResolverResult) obj;
		if (kind == null) {
			if (other.kind != null)
				return false;
		} else if (!kind.equals(other.kind))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}
	
	public static void main(String[] args) {
		System.out.println(ResolverResultKindOfMatchKind.郵便番号辞書match市.getDeclaringClass().getEnumConstants().length);
		
		for (int i = 0; i < 100; i++) {
			System.out.println(i+":" + (1+Math.ceil(Math.log(i)/ Math.log(2)))+":" + Integer.toBinaryString(i-1).length());
		}
	}
	
}