package org.unlaxer.jaddress.parser;

import java.util.Collections;
import java.util.List;

import io.vavr.collection.Stream;


public interface ResolverResultHolder {
	
	public default void add(ResolverResult resolverResult) {
		ResolverResultKind kind = resolverResult.kind;
		
		if(kind instanceof ResolverResultKindOfBoolean) {
			processed().add(resolverResult);
			
		}else if(kind instanceof ResolverResultKindOfProcessedProcessor){
			processedProcessor().add(resolverResult);
			
		}else if(kind instanceof ResolverResultKindOfMatchKind){
			matched().add(resolverResult);
		}
	}
	
	public default Stream<List<ResolverResult>> stream(){
		return Stream.of(processedProcessor(),processed(),matched());
	}
	
	public default String toHyphonedHexes() {
		return 
			ResolverResultOfProcessedProcessorCodec.SINGLETON.toString(processedProcessor())+
			"-"+
			ResolverResultOfBooleanCodec.SINGLETON.toString(processed())+
			"-"+
			ResolverResultOfMatchKindCodec.SINGLETON.toString(matched());
	}
	
	public static ResolverResultHolder fromHex(String hyphonedHexes) {
		
		
		String[] hex = hyphonedHexes.split("-");
		
		return new ResolverResults(
			ResolverResultOfProcessedProcessorCodec.SINGLETON.toResolverResults(()->hex[0])
				.getOrElse(Collections.emptyList()),
			ResolverResultOfBooleanCodec.SINGLETON.toResolverResults(()->hex[1])
				.getOrElse(Collections.emptyList()),
			ResolverResultOfMatchKindCodec.SINGLETON.toResolverResults(()->hex[2])
				.getOrElse(Collections.emptyList())				
		);
	}

	public List<ResolverResult> processedProcessor();
	public List<ResolverResult> processed();
	public List<ResolverResult> matched();
	
}