package org.unlaxer.jaddress.parser;

public enum ResolverResultKindOfBoolean implements ResolverResultKind{
	郵便番号辞書取得済み,
	郵便番号辞書逆引き済み,
	郵便番号辞書町名無し,
	郵便番号辞書町名補完,
	
	//BlockAndBuildingTokenizer
	候補建物名がマッチした,
	
	//HeuristicBlockTokenizer
	Block要素中に号室を発見,
	Block要素の前段のCharacter種類が２個以上,
	Block要素の前段の文字列が3文字以上,
	丁目が最大値を超えた,
	
	
	//丁目階層resolverで取得された階層要素
	expects丁目,
	expects地番,
	expects支号,
	expects枝番号,
	
	//文字列から実際に取得された階層要素
	actual丁目,
	actual地番,
	actual支号,
	actual枝番号,
	
	;
	
	private ResolverResultKindOfBoolean() {
	}

	@Override
	public boolean isBooleanType() {
		return true;
	}

	@Override
	public boolean isMatchKindType() {
		return false;
	}

	@Override
	public boolean isProcessedProcessor() {
		return false;
	}
	
	@Override
	public ResolverResultKind[] valuesAsArray() {
		return ResolverResultKindOfBoolean.values();
	}

}	
	
