package org.unlaxer.jaddress.parser;

import io.vavr.Lazy;

public class ResolverResultKindOfProcessedProcessor implements ResolverResultKind {

	public final ParsingState parsingState;

	public ResolverResultKindOfProcessedProcessor(ParsingState parsingState) {
		super();
		this.parsingState = parsingState;
	}

	@Override
	public boolean isBooleanType() {
		return true;
	}

	@Override
	public boolean isMatchKindType() {
		return false;
	}

	@Override
	public boolean isProcessedProcessor() {
		return true;
	}

	@Override
	public int ordinal() {
		return parsingState.ordinal();
	}

	@Override
	public String name() {
		return parsingState.name();
	}

	@Override
	public ResolverResultKindOfProcessedProcessor[] valuesAsArray() {
		return values.get();
	}
	
	static Lazy<ResolverResultKindOfProcessedProcessor[]> values = Lazy.of(()-> {
		ResolverResultKindOfProcessedProcessor[] values = new ResolverResultKindOfProcessedProcessor[ParsingState.values().length];
		int i=0;
		for (ParsingState parsingState : ParsingState.values()) {
			values[i++] = new ResolverResultKindOfProcessedProcessor(parsingState);
		}
		return values;
	});

}