package org.unlaxer.jaddress.parser;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Supplier;

import org.apache.commons.codec.binary.Hex;
import org.unlaxer.util.function.Unchecked;

import io.vavr.control.Try;

public class ResolverResultOfBooleanCodec implements ResolverResultCodec{
	
	public static final ResolverResultOfBooleanCodec SINGLETON = new ResolverResultOfBooleanCodec();

	@Override
	public Class<? extends ResolverResultKind> target() {
		return ResolverResultKindOfBoolean.class;
	}

	@Override
	public String toString(List<ResolverResult> resolverResultsOfThisKind) {
		BitSet bitSet = new BitSet();
		
		resolverResultsOfThisKind.stream()
			.filter(resolverResult->resolverResult.kind.isBooleanType())
			.forEach(resolverResult->{
				ResolverResultKind kind = resolverResult.kind;
				int ordinal = kind.ordinal();
				bitSet.set(ordinal);
			});
		byte[] bytes = bitSet.toByteArray();
		return Hex.encodeHexString(bytes);
	}

	@Override
	public Try<List<ResolverResult>> toResolverResults(Supplier<String> hexStringOfResolverResults) {
		return  Try.ofSupplier(Unchecked.of(()->{
			
			byte[] decodeHex = Hex.decodeHex(hexStringOfResolverResults.get());
			BitSet bitSet = BitSet.valueOf(decodeHex);
			
			List<ResolverResult> results = new ArrayList<>();
			
			for(int i =0 ; i < bitSet.length() ; i++) {
				
				if(bitSet.get(i)) {
					
					ResolverResultKindOfBoolean resolverResultKindOfBoolean = 
							ResolverResultKindOfBoolean.values()[i];
					
					ResolverResult resolverResult = new ResolverResult(resolverResultKindOfBoolean);
					results.add(resolverResult);
				}
			}
			return results;
		}));
	}
}