package org.unlaxer.jaddress.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import org.unlaxer.jaddress.parser.MatchKind.MatchKindCodec;

import io.vavr.control.Try;

public class ResolverResultOfMatchKindCodec implements ResolverResultCodec{
	
	public static final ResolverResultOfMatchKindCodec SINGLETON = new ResolverResultOfMatchKindCodec();

	
	private final MatchKindCodec matchKindCodec ;

	public ResolverResultOfMatchKindCodec() {
		super();
		matchKindCodec = new MatchKindCodec();
	}

	@Override
	public Class<? extends ResolverResultKind> target() {
		return ResolverResultKindOfMatchKind.class;
	}

	@Override
	public String toString(List<ResolverResult> resolverResultsOfThisKind) {
		
		StringBuilder builder = new StringBuilder();
		
		for (ResolverResultKindOfMatchKind  kind :ResolverResultKindOfMatchKind .values()) {

			boolean exists =false;
			
			for (ResolverResult resolverResult : resolverResultsOfThisKind) {
				
				ResolverResultKind targetKind = resolverResult.kind();
				
				MatchKind value = MatchKind.class.cast(resolverResult.value());
				
				if(targetKind == kind) {
					builder.append(matchKindCodec.encode(value));
					exists = true ; 
					break;
				}
			}
			if(exists ==false) {
				builder.append("0");
			}
		}
		return builder.toString();
	}

	@Override
	public Try<List<ResolverResult>> toResolverResults(Supplier<String> hexStringOfResolverResults) {
		
		return Try.ofSupplier(()->{
			
			int length = hexStringOfResolverResults.get().length();
			
			List<ResolverResult> results = new ArrayList<>();
			
			ResolverResultKindOfMatchKind[] resolverResultKindOfMatchKinds = 
					ResolverResultKindOfMatchKind .values();
			
			for(int i = 0; i  < length ; i ++) {
				
				String target = hexStringOfResolverResults.get().substring(i,i+1);
				if(target.equals("0")) {
					continue;
				}
				ResolverResultKindOfMatchKind resolverResultKindOfMatchKind = 
						resolverResultKindOfMatchKinds[i];
				
				MatchKind decode = matchKindCodec.decode(target);
				
				ResolverResult resolverResult = new ResolverResult(resolverResultKindOfMatchKind , decode);
				
				results.add(resolverResult);
			}
			return results;
		});
	}
}